/*
 * Decompiled with CFR 0.152.
 */
package minetweaker.mc1112.brackets;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import minetweaker.IBracketHandler;
import minetweaker.MineTweakerAPI;
import minetweaker.annotations.BracketHandler;
import minetweaker.api.entity.IEntityDefinition;
import stanhebben.zenscript.compiler.IEnvironmentGlobal;
import stanhebben.zenscript.expression.ExpressionCallStatic;
import stanhebben.zenscript.expression.ExpressionString;
import stanhebben.zenscript.expression.partial.IPartialExpression;
import stanhebben.zenscript.parser.Token;
import stanhebben.zenscript.symbols.IZenSymbol;
import stanhebben.zenscript.type.natives.IJavaMethod;
import stanhebben.zenscript.util.ZenPosition;

@BracketHandler(priority=100)
public class EntityBracketHandler
implements IBracketHandler {
    private static final Map<String, IEntityDefinition> entityNames = new HashMap<String, IEntityDefinition>();
    private final IJavaMethod method = MineTweakerAPI.getJavaMethod(EntityBracketHandler.class, "getEntity", String.class);

    public static void rebuildEntityRegistry() {
        entityNames.clear();
        MineTweakerAPI.game.getEntities().forEach(ent -> entityNames.put(ent.getName().toLowerCase(), (IEntityDefinition)ent));
    }

    public static IEntityDefinition getEntity(String name) {
        return entityNames.get(name.toLowerCase());
    }

    @Override
    public IZenSymbol resolve(IEnvironmentGlobal environment, List<Token> tokens) {
        if (tokens.size() > 2 && tokens.get(0).getValue().equals("entity") && tokens.get(1).getValue().equals(":")) {
            return this.find(environment, tokens, 2, tokens.size());
        }
        return null;
    }

    private IZenSymbol find(IEnvironmentGlobal environment, List<Token> tokens, int startIndex, int endIndex) {
        StringBuilder valueBuilder = new StringBuilder();
        for (int i = startIndex; i < endIndex; ++i) {
            Token token = tokens.get(i);
            valueBuilder.append(token.getValue());
        }
        return new EntityReferenceSymbol(environment, valueBuilder.toString());
    }

    private class EntityReferenceSymbol
    implements IZenSymbol {
        private final IEnvironmentGlobal environment;
        private final String name;

        public EntityReferenceSymbol(IEnvironmentGlobal environment, String name) {
            this.environment = environment;
            this.name = name;
        }

        @Override
        public IPartialExpression instance(ZenPosition position) {
            return new ExpressionCallStatic(position, this.environment, EntityBracketHandler.this.method, new ExpressionString(position, this.name));
        }
    }
}

