/*
 * Decompiled with CFR 0.152.
 */
package minetweaker.mc1112.entity;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import minetweaker.api.entity.IEntityDefinition;
import minetweaker.api.item.IItemStack;
import net.minecraft.entity.Entity;
import stanhebben.zenscript.value.IntRange;

public class MCEntityDefinition
implements IEntityDefinition {
    private final Class<? extends Entity> entityClass;
    private final String entityName;
    private final Map<IItemStack, IntRange> dropsToAdd = new HashMap<IItemStack, IntRange>();
    private final Map<IItemStack, IntRange> dropsToAddPlayerOnly = new HashMap<IItemStack, IntRange>();
    private final List<IItemStack> dropsToRemove = new ArrayList<IItemStack>();

    public MCEntityDefinition(Class<? extends Entity> entityClass, String entityName) {
        this.entityClass = entityClass;
        this.entityName = entityName;
    }

    @Override
    public String getId() {
        return this.entityClass.getName();
    }

    @Override
    public String getName() {
        return this.entityName;
    }

    @Override
    public void addDrop(IItemStack stack, int min, int max) {
        this.dropsToAdd.put(stack, new IntRange(min, max));
    }

    @Override
    public void addPlayerOnlyDrop(IItemStack stack, int min, int max) {
        this.dropsToAddPlayerOnly.put(stack, new IntRange(min, max));
    }

    @Override
    public void removeDrop(IItemStack stack) {
        this.dropsToRemove.add(stack);
    }

    @Override
    public Map<IItemStack, IntRange> getDropsToAdd() {
        return this.dropsToAdd;
    }

    @Override
    public Map<IItemStack, IntRange> getDropsToAddPlayerOnly() {
        return this.dropsToAddPlayerOnly;
    }

    @Override
    public List<IItemStack> getDropsToRemove() {
        return this.dropsToRemove;
    }
}

