/*
 * Decompiled with CFR 0.152.
 */
package minetweaker.mc1112.furnace;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import minetweaker.api.minecraft.MineTweakerMC;
import minetweaker.api.recipes.FurnaceRecipe;
import minetweaker.api.recipes.IFurnaceManager;
import minetweaker.api.recipes.IFurnaceRecipe;
import minetweaker.mc1112.furnace.FuelTweaker;
import minetweaker.mc1112.furnace.SetFuelPattern;
import minetweaker.mc1112.item.MCItemStack;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraftforge.fml.common.registry.GameRegistry;
import stanhebben.zenscript.annotations.Optional;

public class MCFurnaceManager
implements IFurnaceManager {
    @Override
    public void remove(IIngredient output, @Optional IIngredient input) {
        if (output == null) {
            throw new IllegalArgumentException("output cannot be null");
        }
        Map smeltingList = FurnaceRecipes.func_77602_a().func_77599_b();
        ArrayList<ItemStack> toRemove = new ArrayList<ItemStack>();
        ArrayList<ItemStack> toRemoveValues = new ArrayList<ItemStack>();
        if (input == null) {
            for (Map.Entry entry : smeltingList.entrySet()) {
                if (!output.matches(MineTweakerMC.getIItemStack((ItemStack)entry.getValue()))) continue;
                toRemove.add((ItemStack)entry.getKey());
                toRemoveValues.add((ItemStack)entry.getValue());
            }
        } else {
            for (Map.Entry entry : smeltingList.entrySet()) {
                if (!output.matches(MineTweakerMC.getIItemStack((ItemStack)entry.getValue())) || !input.matches(MineTweakerMC.getIItemStack((ItemStack)entry.getKey()))) continue;
                toRemove.add((ItemStack)entry.getKey());
                toRemoveValues.add((ItemStack)entry.getValue());
            }
        }
        if (toRemove.isEmpty()) {
            MineTweakerAPI.logWarning("No furnace recipes for " + output.toString());
        } else {
            MineTweakerAPI.apply(new RemoveAction(toRemove, toRemoveValues));
        }
    }

    @Override
    public void addRecipe(IItemStack output, IIngredient input, @Optional double xp) {
        List<IItemStack> items = input.getItems();
        if (items == null) {
            MineTweakerAPI.logError("Cannot turn " + input.toString() + " into a furnace recipe");
        }
        ItemStack[] items2 = MineTweakerMC.getItemStacks(items);
        ItemStack output2 = MineTweakerMC.getItemStack(output);
        MineTweakerAPI.apply(new AddRecipeAction(input, items2, output2, xp));
    }

    @Override
    public void setFuel(IIngredient item, int fuel) {
        MineTweakerAPI.apply(new SetFuelAction(new SetFuelPattern(item, fuel)));
    }

    @Override
    public int getFuel(IItemStack item) {
        return GameRegistry.getFuelValue((ItemStack)MineTweakerMC.getItemStack(item));
    }

    @Override
    public List<IFurnaceRecipe> getAll() {
        return FurnaceRecipes.func_77602_a().func_77599_b().entrySet().stream().map(ent -> new FurnaceRecipe(new MCItemStack((ItemStack)ent.getKey()), new MCItemStack((ItemStack)ent.getValue()), FurnaceRecipes.func_77602_a().func_151398_b((ItemStack)ent.getValue()))).collect(Collectors.toList());
    }

    private static class SetFuelAction
    implements IUndoableAction {
        private final SetFuelPattern pattern;

        public SetFuelAction(SetFuelPattern pattern) {
            this.pattern = pattern;
        }

        @Override
        public void apply() {
            FuelTweaker.INSTANCE.addFuelPattern(this.pattern);
        }

        @Override
        public boolean canUndo() {
            return true;
        }

        @Override
        public void undo() {
            FuelTweaker.INSTANCE.removeFuelPattern(this.pattern);
        }

        @Override
        public String describe() {
            return "Setting fuel for " + this.pattern.getPattern();
        }

        @Override
        public String describeUndo() {
            return "Removing fuel for " + this.pattern.getPattern();
        }

        @Override
        public Object getOverrideKey() {
            return null;
        }
    }

    private static class AddRecipeAction
    implements IUndoableAction {
        private final IIngredient ingredient;
        private final ItemStack[] input;
        private final ItemStack output;
        private final double xp;

        public AddRecipeAction(IIngredient ingredient, ItemStack[] input, ItemStack output, double xp) {
            this.ingredient = ingredient;
            this.input = input;
            this.output = output;
            this.xp = xp;
        }

        @Override
        public void apply() {
            for (ItemStack inputStack : this.input) {
                FurnaceRecipes.func_77602_a().func_151394_a(inputStack, this.output, (float)this.xp);
            }
            MineTweakerAPI.getIjeiRecipeRegistry().addFurnace(Arrays.asList(this.input), this.output);
        }

        @Override
        public boolean canUndo() {
            return true;
        }

        @Override
        public void undo() {
            for (ItemStack inputStack : this.input) {
                FurnaceRecipes.func_77602_a().func_77599_b().remove(inputStack);
                MineTweakerAPI.getIjeiRecipeRegistry().removeFurnace(inputStack);
            }
        }

        @Override
        public String describe() {
            return "Adding furnace recipe for " + this.ingredient;
        }

        @Override
        public String describeUndo() {
            return "Removing furnace recipe for " + this.ingredient;
        }

        @Override
        public Object getOverrideKey() {
            return null;
        }
    }

    private static class RemoveAction
    implements IUndoableAction {
        private final List<ItemStack> items;
        private final List<ItemStack> values;

        public RemoveAction(List<ItemStack> items, List<ItemStack> values) {
            this.items = items;
            this.values = values;
        }

        @Override
        public void apply() {
            for (ItemStack item : this.items) {
                FurnaceRecipes.func_77602_a().func_77599_b().remove(item);
                MineTweakerAPI.getIjeiRecipeRegistry().removeFurnace(item);
            }
        }

        @Override
        public boolean canUndo() {
            return true;
        }

        @Override
        public void undo() {
            for (int i = 0; i < this.items.size(); ++i) {
                FurnaceRecipes.func_77602_a().func_77599_b().put(this.items.get(i), this.values.get(i));
                MineTweakerAPI.getIjeiRecipeRegistry().addFurnace(Arrays.asList(this.items.toArray()), this.values.get(i));
            }
        }

        @Override
        public String describe() {
            return "Removing " + this.items.size() + " furnace recipes";
        }

        @Override
        public String describeUndo() {
            return "Restoring " + this.items.size() + " furnace recipes";
        }

        @Override
        public Object getOverrideKey() {
            return null;
        }
    }
}

