/*
 * Decompiled with CFR 0.152.
 */
package minetweaker.mc1112.game;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.block.IBlockDefinition;
import minetweaker.api.entity.IEntityDefinition;
import minetweaker.api.game.IGame;
import minetweaker.api.item.IItemDefinition;
import minetweaker.api.liquid.ILiquidDefinition;
import minetweaker.api.minecraft.MineTweakerMC;
import minetweaker.api.world.IBiome;
import minetweaker.mc1112.entity.MCEntityDefinition;
import minetweaker.mc1112.item.MCItemDefinition;
import minetweaker.mc1112.liquid.MCLiquidDefinition;
import minetweaker.mc1112.util.MineTweakerHacks;
import minetweaker.mc1112.util.MineTweakerPlatformUtils;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class MCGame
implements IGame {
    public static final MCGame INSTANCE = new MCGame();
    private static final Map<String, String> TRANSLATIONS = MineTweakerHacks.getTranslations();
    private static final List<IEntityDefinition> ENTITY_DEFINITIONS = new ArrayList<IEntityDefinition>();
    private boolean locked = false;

    private MCGame() {
    }

    @Override
    public List<IItemDefinition> getItems() {
        return Item.field_150901_e.func_148742_b().stream().map(item -> new MCItemDefinition(item.toString(), (Item)Item.field_150901_e.func_82594_a(item))).collect(Collectors.toList());
    }

    @Override
    public List<IBlockDefinition> getBlocks() {
        return Block.field_149771_c.func_148742_b().stream().map(block -> MineTweakerMC.getBlockDefinition((Block)Block.field_149771_c.func_82594_a(block))).collect(Collectors.toList());
    }

    @Override
    public List<ILiquidDefinition> getLiquids() {
        return FluidRegistry.getRegisteredFluids().entrySet().stream().map(entry -> new MCLiquidDefinition((Fluid)entry.getValue())).collect(Collectors.toList());
    }

    @Override
    public List<IBiome> getBiomes() {
        ArrayList<IBiome> result = new ArrayList<IBiome>();
        for (IBiome biome : MineTweakerMC.biomes) {
            if (biome == null) continue;
            result.add(biome);
        }
        return result;
    }

    @Override
    public List<IEntityDefinition> getEntities() {
        if (Iterables.size((Iterable)ForgeRegistries.ENTITIES) != ENTITY_DEFINITIONS.size()) {
            ENTITY_DEFINITIONS.clear();
            ForgeRegistries.ENTITIES.forEach(entry -> ENTITY_DEFINITIONS.add(new MCEntityDefinition(entry.getEntityClass(), entry.getName())));
        }
        return ENTITY_DEFINITIONS;
    }

    @Override
    public IEntityDefinition getEntity(String entityName) {
        for (IEntityDefinition ent2 : this.getEntities()) {
            if (!ent2.getName().equalsIgnoreCase(entityName)) continue;
            return ent2;
        }
        boolean needsReloading = false;
        for (ResourceLocation res : ForgeRegistries.ENTITIES.getKeys()) {
            if (!res.func_110623_a().equalsIgnoreCase(entityName)) continue;
            needsReloading = true;
            break;
        }
        if (needsReloading) {
            ENTITY_DEFINITIONS.clear();
            ForgeRegistries.ENTITIES.forEach(entry -> ENTITY_DEFINITIONS.add(new MCEntityDefinition(entry.getEntityClass(), entry.getName())));
        }
        return this.getEntities().stream().filter(ent -> ent.getName().equals(entityName)).findFirst().orElse(null);
    }

    @Override
    public void setLocalization(String key, String value) {
        MineTweakerAPI.apply(new SetTranslation(null, key, value));
    }

    @Override
    public void setLocalization(String lang, String key, String value) {
        MineTweakerAPI.apply(new SetTranslation(lang, key, value));
    }

    @Override
    public String localize(String key) {
        return I18n.func_74838_a((String)key);
    }

    @Override
    public String localize(String key, String lang) {
        return I18n.func_74838_a((String)key);
    }

    @Override
    public void lock() {
        this.locked = true;
    }

    @Override
    public boolean isLocked() {
        return this.locked;
    }

    @Override
    public void signalLockError() {
        MineTweakerAPI.getLogger().logError("Reload of scripts blocked (script lock)");
        if (Minecraft.func_71382_s()) {
            // empty if block
        }
    }

    private static class SetTranslation
    implements IUndoableAction {
        private final String lang;
        private final String key;
        private final String text;
        private String original;
        private boolean added;

        public SetTranslation(String lang, String key, String text) {
            this.lang = lang;
            this.key = key;
            this.text = text;
        }

        @Override
        public void apply() {
            if (this.lang == null || MineTweakerPlatformUtils.isLanguageActive(this.lang)) {
                this.original = (String)TRANSLATIONS.get(this.key);
                TRANSLATIONS.put(this.key, this.text);
                this.added = true;
            } else {
                this.added = false;
            }
        }

        @Override
        public boolean canUndo() {
            return TRANSLATIONS != null;
        }

        @Override
        public void undo() {
            if (this.added) {
                if (this.original == null) {
                    TRANSLATIONS.remove(this.key);
                } else {
                    TRANSLATIONS.put(this.key, this.original);
                }
            }
        }

        @Override
        public String describe() {
            return "Setting localization for the key: " + this.key + " to " + this.text;
        }

        @Override
        public String describeUndo() {
            return "Setting localization for the key: " + this.key + " to " + this.original;
        }

        @Override
        public Object getOverrideKey() {
            return null;
        }
    }
}

