/*
 * Decompiled with CFR 0.152.
 */
package minetweaker.mc1112.oredict;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemCondition;
import minetweaker.api.item.IItemStack;
import minetweaker.api.item.IItemTransformer;
import minetweaker.api.item.IngredientOr;
import minetweaker.api.item.IngredientStack;
import minetweaker.api.liquid.ILiquidStack;
import minetweaker.api.minecraft.MineTweakerMC;
import minetweaker.api.oredict.IOreDictEntry;
import minetweaker.api.oredict.IngredientOreDict;
import minetweaker.api.player.IPlayer;
import minetweaker.mc1112.util.MineTweakerHacks;
import minetweaker.util.ArrayUtil;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.oredict.OreDictionary;

public class MCOreDictEntry
implements IOreDictEntry {
    private static final List<NonNullList<ItemStack>> OREDICT_CONTENTS = MineTweakerHacks.getOreIdStacks();
    private static final List<NonNullList<ItemStack>> OREDICT_CONTENTS_UN = MineTweakerHacks.getOreIdStacksUn();
    private final String id;

    public MCOreDictEntry(String id) {
        this.id = id;
    }

    private static void reloadJEIItem(ItemStack stack) {
        MineTweakerAPI.getIjeiRecipeRegistry().removeItem(stack);
        MineTweakerAPI.getIjeiRecipeRegistry().addItem(stack);
    }

    @Override
    public String getName() {
        return this.id;
    }

    @Override
    public boolean isEmpty() {
        return OreDictionary.getOres((String)this.getName()).isEmpty();
    }

    @Override
    public IItemStack getFirstItem() {
        return this.getItems().get(0);
    }

    @Override
    public void add(IItemStack item) {
        ItemStack stack = MineTweakerMC.getItemStack(item);
        if (!stack.func_190926_b()) {
            MineTweakerAPI.apply(new ActionAddItem(this.id, stack));
        }
    }

    @Override
    public void addItems(IItemStack[] items) {
        for (IItemStack item : items) {
            ItemStack stack = MineTweakerMC.getItemStack(item);
            if (stack.func_190926_b()) continue;
            MineTweakerAPI.apply(new ActionAddItem(this.id, stack));
        }
    }

    @Override
    public void addAll(IOreDictEntry entry) {
        if (entry instanceof MCOreDictEntry) {
            MineTweakerAPI.apply(new ActionAddAll(this.id, ((MCOreDictEntry)entry).id));
        } else {
            MineTweakerAPI.logError("not a valid entry");
        }
    }

    @Override
    public void remove(IItemStack item) {
        ItemStack result = ItemStack.field_190927_a;
        for (ItemStack itemStack : OreDictionary.getOres((String)this.getName())) {
            if (!item.matches(MineTweakerMC.getIItemStackWildcardSize(itemStack))) continue;
            result = itemStack;
            break;
        }
        if (!result.func_190926_b()) {
            MineTweakerAPI.apply(new ActionRemoveItem(this.id, result));
        }
    }

    @Override
    public void removeItems(IItemStack[] items) {
        for (IItemStack item : items) {
            ItemStack result = ItemStack.field_190927_a;
            for (ItemStack itemStack : OreDictionary.getOres((String)this.id)) {
                if (!item.matches(MineTweakerMC.getIItemStackWildcardSize(itemStack))) continue;
                result = itemStack;
                break;
            }
            if (result.func_190926_b()) continue;
            MineTweakerAPI.apply(new ActionRemoveItem(this.id, result));
        }
    }

    @Override
    public boolean contains(IItemStack item) {
        for (ItemStack itemStack : OreDictionary.getOres((String)this.getName())) {
            if (!MineTweakerMC.getIItemStackWildcardSize(itemStack).matches(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void mirror(IOreDictEntry other) {
        if (other instanceof MCOreDictEntry) {
            MineTweakerAPI.apply(new ActionMirror(this.id, ((MCOreDictEntry)other).id));
        } else {
            MineTweakerAPI.logError("not a valid oredict entry");
        }
    }

    @Override
    public String getMark() {
        return null;
    }

    @Override
    public int getAmount() {
        return 1;
    }

    @Override
    public List<IItemStack> getItems() {
        return OreDictionary.getOres((String)this.getName()).stream().map(MineTweakerMC::getIItemStackWildcardSize).collect(Collectors.toList());
    }

    @Override
    public List<ILiquidStack> getLiquids() {
        return Collections.emptyList();
    }

    @Override
    public IIngredient amount(int amount) {
        return new IngredientStack(this, amount);
    }

    @Override
    public IIngredient transform(IItemTransformer transformer) {
        return new IngredientOreDict(this, null, ArrayUtil.EMPTY_CONDITIONS, new IItemTransformer[]{transformer});
    }

    @Override
    public IIngredient only(IItemCondition condition) {
        return new IngredientOreDict(this, null, new IItemCondition[]{condition}, ArrayUtil.EMPTY_TRANSFORMERS);
    }

    @Override
    public IIngredient marked(String mark) {
        return new IngredientOreDict(this, mark, ArrayUtil.EMPTY_CONDITIONS, ArrayUtil.EMPTY_TRANSFORMERS);
    }

    @Override
    public IIngredient or(IIngredient ingredient) {
        return new IngredientOr(this, ingredient);
    }

    @Override
    public boolean matches(IItemStack item) {
        return this.contains(item);
    }

    @Override
    public boolean matchesExact(IItemStack item) {
        return this.contains(item);
    }

    @Override
    public boolean matches(ILiquidStack liquid) {
        return false;
    }

    @Override
    public boolean contains(IIngredient ingredient) {
        List<IItemStack> items = ingredient.getItems();
        for (IItemStack item : items) {
            if (this.matches(item)) continue;
            return false;
        }
        return true;
    }

    @Override
    public IItemStack applyTransform(IItemStack item, IPlayer byPlayer) {
        return item;
    }

    @Override
    public boolean hasTransformers() {
        return false;
    }

    @Override
    public Object getInternal() {
        return this.id;
    }

    public String toString() {
        return "<ore:" + this.id + ">";
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object other) {
        return other instanceof MCOreDictEntry && Objects.equals(((MCOreDictEntry)other).id, this.id);
    }

    private static class ActionAddAll
    implements IUndoableAction {
        private final String idTarget;
        private final String idSource;

        public ActionAddAll(String idTarget, String idSource) {
            this.idTarget = idTarget;
            this.idSource = idSource;
        }

        @Override
        public void apply() {
            for (ItemStack stack : OreDictionary.getOres((String)this.idSource)) {
                OreDictionary.registerOre((String)this.idTarget, (ItemStack)stack);
            }
            OreDictionary.getOres((String)this.idSource).forEach(x$0 -> MCOreDictEntry.reloadJEIItem(x$0));
        }

        @Override
        public boolean canUndo() {
            return true;
        }

        @Override
        public void undo() {
            int targetOreId = OreDictionary.getOreID((String)this.idTarget);
            NonNullList targetOres = OreDictionary.getOres((String)this.idTarget);
            ArrayList<ItemStack> removeStacks = new ArrayList<ItemStack>();
            block0: for (ItemStack stack : OreDictionary.getOres((String)this.idSource)) {
                for (ItemStack target : targetOres) {
                    if (!ItemStack.func_77989_b((ItemStack)target, (ItemStack)stack)) continue;
                    removeStacks.add(target);
                    continue block0;
                }
            }
            for (ItemStack stack : removeStacks) {
                ((NonNullList)OREDICT_CONTENTS.get(targetOreId)).remove((Object)stack);
            }
            OreDictionary.rebakeMap();
            removeStacks.forEach(x$0 -> MCOreDictEntry.reloadJEIItem(x$0));
        }

        @Override
        public String describe() {
            return "Copying contents of ore dictionary entry " + this.idSource + " to " + this.idTarget;
        }

        @Override
        public String describeUndo() {
            return "Removing contents of ore dictionary entry " + this.idSource + " from " + this.idTarget;
        }

        @Override
        public Object getOverrideKey() {
            return null;
        }
    }

    private static class ActionRemoveItem
    implements IUndoableAction {
        private final String id;
        private final ItemStack item;

        public ActionRemoveItem(String id, ItemStack item) {
            this.id = id;
            this.item = item;
        }

        @Override
        public void apply() {
            int oreId = OreDictionary.getOreID((String)this.id);
            ((NonNullList)OREDICT_CONTENTS.get(oreId)).remove((Object)this.item);
            OreDictionary.rebakeMap();
            MCOreDictEntry.reloadJEIItem(this.item);
        }

        @Override
        public boolean canUndo() {
            return true;
        }

        @Override
        public void undo() {
            int oreId = OreDictionary.getOreID((String)this.id);
            ((NonNullList)OREDICT_CONTENTS.get(oreId)).add((Object)this.item);
            OreDictionary.rebakeMap();
            MCOreDictEntry.reloadJEIItem(this.item);
        }

        @Override
        public String describe() {
            return "Removing " + this.item.func_82833_r() + " from ore dictionary entry " + this.id;
        }

        @Override
        public String describeUndo() {
            return "Restoring " + this.item.func_82833_r() + " to ore dictionary entry " + this.id;
        }

        @Override
        public Object getOverrideKey() {
            return null;
        }
    }

    private static class ActionMirror
    implements IUndoableAction {
        private final String idTarget;
        private final String idSource;
        private final NonNullList<ItemStack> targetCopy;
        private final NonNullList<ItemStack> targetCopyUn;

        public ActionMirror(String idTarget, String idSource) {
            this.idTarget = idTarget;
            this.idSource = idSource;
            int targetOreId = OreDictionary.getOreID((String)idTarget);
            this.targetCopy = (NonNullList)OREDICT_CONTENTS.get(targetOreId);
            this.targetCopyUn = (NonNullList)OREDICT_CONTENTS_UN.get(targetOreId);
        }

        @Override
        public void apply() {
            int sourceOreId = OreDictionary.getOreID((String)this.idSource);
            int targetOreId = OreDictionary.getOreID((String)this.idTarget);
            OREDICT_CONTENTS.set(targetOreId, OREDICT_CONTENTS.get(sourceOreId));
            OREDICT_CONTENTS_UN.set(targetOreId, OREDICT_CONTENTS_UN.get(sourceOreId));
            OreDictionary.rebakeMap();
            this.targetCopy.forEach(x$0 -> MCOreDictEntry.reloadJEIItem(x$0));
            this.targetCopyUn.forEach(x$0 -> MCOreDictEntry.reloadJEIItem(x$0));
        }

        @Override
        public boolean canUndo() {
            return true;
        }

        @Override
        public void undo() {
            int targetOreId = OreDictionary.getOreID((String)this.idTarget);
            OREDICT_CONTENTS.set(targetOreId, this.targetCopy);
            OREDICT_CONTENTS_UN.set(targetOreId, this.targetCopyUn);
            OreDictionary.rebakeMap();
            this.targetCopy.forEach(x$0 -> MCOreDictEntry.reloadJEIItem(x$0));
            this.targetCopyUn.forEach(x$0 -> MCOreDictEntry.reloadJEIItem(x$0));
        }

        @Override
        public String describe() {
            return "Mirroring " + this.idSource + " to " + this.idTarget;
        }

        @Override
        public String describeUndo() {
            return "Undoing mirror of " + this.idSource + " to " + this.idTarget;
        }

        @Override
        public Object getOverrideKey() {
            return null;
        }
    }

    private static class ActionAddItem
    implements IUndoableAction {
        private final String id;
        private final ItemStack item;

        public ActionAddItem(String id, ItemStack item) {
            this.id = id;
            this.item = item;
        }

        @Override
        public void apply() {
            OreDictionary.registerOre((String)this.id, (ItemStack)this.item);
            MCOreDictEntry.reloadJEIItem(this.item);
        }

        @Override
        public boolean canUndo() {
            return true;
        }

        @Override
        public void undo() {
            int oreId = OreDictionary.getOreID((String)this.id);
            ItemStack removeStack = this.item;
            for (ItemStack stack : OreDictionary.getOres((String)this.id)) {
                if (!ItemStack.func_77989_b((ItemStack)this.item, (ItemStack)stack)) continue;
                removeStack = stack;
                break;
            }
            ((NonNullList)OREDICT_CONTENTS.get(oreId)).remove((Object)removeStack);
            OreDictionary.rebakeMap();
            MCOreDictEntry.reloadJEIItem(removeStack);
        }

        @Override
        public String describe() {
            return "Adding " + this.item.func_82833_r() + " to ore dictionary entry " + this.id;
        }

        @Override
        public String describeUndo() {
            return "Removing " + this.item.func_82833_r() + " from ore dictionary entry " + this.id;
        }

        @Override
        public Object getOverrideKey() {
            return null;
        }
    }
}

