/*
 * Decompiled with CFR 0.152.
 */
package minetweaker.mc1112.server;

import java.util.Arrays;
import java.util.List;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.minecraft.MineTweakerMC;
import minetweaker.api.player.IPlayer;
import minetweaker.api.server.AbstractServer;
import minetweaker.api.server.ICommandFunction;
import minetweaker.api.server.ICommandTabCompletion;
import minetweaker.api.server.ICommandValidator;
import minetweaker.mc1112.MineTweakerMod;
import minetweaker.mc1112.player.CommandBlockPlayer;
import minetweaker.mc1112.player.RconPlayer;
import minetweaker.mc1112.server.ServerPlayer;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandHandler;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.rcon.RConConsoleSource;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.UserListOps;
import net.minecraft.tileentity.CommandBlockBaseLogic;
import net.minecraft.util.math.BlockPos;
import stanhebben.zenscript.annotations.Optional;

public class MCServer
extends AbstractServer {
    private final MinecraftServer server;

    public MCServer(MinecraftServer server) {
        this.server = server;
    }

    private static IPlayer getPlayer(ICommandSender commandSender) {
        if (commandSender instanceof EntityPlayer) {
            return MineTweakerMC.getIPlayer((EntityPlayer)commandSender);
        }
        if (commandSender instanceof RConConsoleSource) {
            return new RconPlayer(commandSender);
        }
        if (commandSender instanceof CommandBlockBaseLogic) {
            return new CommandBlockPlayer(commandSender);
        }
        if (commandSender.func_70005_c_().equals("Server")) {
            return ServerPlayer.INSTANCE;
        }
        System.out.println("Unsupported command sender: " + commandSender + " defaulting to server player!");
        System.out.println("player name: " + commandSender.func_70005_c_());
        System.out.println("Please report to mod author if this is incorrect!");
        return ServerPlayer.INSTANCE;
    }

    @Override
    public void addCommand(String name, String usage, String[] aliases, ICommandFunction function, @Optional ICommandValidator validator, @Optional ICommandTabCompletion completion) {
        MCCommand command = new MCCommand(name, usage, aliases, function, validator, completion);
        MineTweakerAPI.apply(new AddCommandAction(command));
    }

    @Override
    public boolean isOp(IPlayer player) {
        if (player == ServerPlayer.INSTANCE) {
            return true;
        }
        UserListOps ops = MineTweakerMod.server.func_184103_al().func_152603_m();
        if (this.server != null && this.server.func_71262_S() && ops != null) {
            return ops.func_152690_d() || ops.func_152700_a(player.getName()) != null || player instanceof RconPlayer;
        }
        return true;
    }

    @Override
    public boolean isCommandAdded(String name) {
        return MineTweakerMod.server.func_71187_D().func_71555_a().containsKey(name);
    }

    private class AddCommandAction
    implements IUndoableAction {
        private final ICommand command;

        public AddCommandAction(ICommand command) {
            this.command = command;
        }

        @Override
        public void apply() {
            CommandHandler ch = (CommandHandler)MineTweakerMod.server.func_71187_D();
            if (!ch.func_71555_a().containsValue(this.command)) {
                ch.func_71560_a(this.command);
            }
        }

        @Override
        public boolean canUndo() {
            return true;
        }

        @Override
        public void undo() {
        }

        @Override
        public String describe() {
            CommandHandler ch = (CommandHandler)MineTweakerMod.server.func_71187_D();
            if (!ch.func_71555_a().containsValue(this.command)) {
                return "Adding command " + this.command.func_71517_b();
            }
            return "";
        }

        @Override
        public String describeUndo() {
            return "tried to remove command: " + this.command.func_71517_b() + " failed. THIS IS NOT AN ERROR!";
        }

        @Override
        public Object getOverrideKey() {
            return null;
        }
    }

    private class MCCommand
    implements ICommand {
        private final String name;
        private final String usage;
        private final List<String> aliases;
        private final ICommandFunction function;
        private final ICommandValidator validator;
        private final ICommandTabCompletion completion;

        public MCCommand(String name, String usage, String[] aliases, ICommandFunction function, ICommandValidator validator, ICommandTabCompletion completion) {
            this.name = name;
            this.usage = usage;
            this.aliases = Arrays.asList(aliases);
            this.function = function;
            this.validator = validator;
            this.completion = completion;
        }

        public String func_71517_b() {
            return this.name;
        }

        public String func_71518_a(ICommandSender var1) {
            return this.usage;
        }

        public List func_71514_a() {
            return this.aliases;
        }

        public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
            this.function.execute(args, MCServer.getPlayer(sender));
        }

        public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
            if (this.validator == null) {
                return true;
            }
            return this.validator.canExecute(MCServer.getPlayer(sender));
        }

        public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos pos) {
            if (this.completion != null) {
                return Arrays.asList(this.completion.getTabCompletionOptions(args, MCServer.getPlayer(sender)));
            }
            return null;
        }

        public boolean func_82358_a(String[] var1, int var2) {
            return false;
        }

        public int compareTo(ICommand o) {
            return this.func_71517_b().compareTo(o.func_71517_b());
        }
    }
}

