/*
 * Decompiled with CFR 0.152.
 */
package minetweaker.mc1112.vanilla;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import minetweaker.api.item.WeightedItemStack;
import minetweaker.api.minecraft.MineTweakerMC;
import minetweaker.api.vanilla.ISeedRegistry;
import minetweaker.mc1112.util.MineTweakerHacks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.WeightedRandom;

public class MCSeedRegistry
implements ISeedRegistry {
    private static final List SEEDS = MineTweakerHacks.getSeeds();

    @Override
    public void addSeed(WeightedItemStack item) {
        MineTweakerAPI.apply(new AddSeedAction(item));
    }

    @Override
    public void removeSeed(IIngredient pattern) {
        MineTweakerAPI.apply(new RemoveSeedAction(pattern));
    }

    @Override
    public List<WeightedItemStack> getSeeds() {
        List entries = SEEDS;
        return entries.stream().map(entry -> new WeightedItemStack(MineTweakerMC.getIItemStack(MineTweakerHacks.getSeedEntrySeed(entry)), entry.field_76292_a)).collect(Collectors.toList());
    }

    private static class RemoveSeedAction
    implements IUndoableAction {
        private final IIngredient pattern;
        private final List<Object> removed;

        public RemoveSeedAction(IIngredient ingredient) {
            this.pattern = ingredient;
            this.removed = new ArrayList<Object>();
        }

        @Override
        public void apply() {
            this.removed.clear();
            for (Object e : SEEDS) {
                ItemStack itemStack = MineTweakerHacks.getSeedEntrySeed(e);
                if (!this.pattern.matches(MineTweakerMC.getIItemStack(itemStack))) continue;
                this.removed.add(e);
            }
            for (Object object : this.removed) {
                SEEDS.remove(object);
            }
        }

        @Override
        public boolean canUndo() {
            return true;
        }

        @Override
        public void undo() {
            SEEDS.addAll(this.removed);
        }

        @Override
        public String describe() {
            return "Removing seeds " + this.pattern;
        }

        @Override
        public String describeUndo() {
            return "Restoring seeds " + this.pattern + " (" + this.removed.size() + " entries)";
        }

        @Override
        public Object getOverrideKey() {
            return null;
        }
    }

    private static class AddSeedAction
    implements IUndoableAction {
        private final IItemStack item;
        private final WeightedRandom.Item entry;

        public AddSeedAction(WeightedItemStack item) {
            this.item = item.getStack();
            this.entry = MineTweakerHacks.constructSeedEntry(item);
        }

        @Override
        public void apply() {
            SEEDS.add(this.entry);
        }

        @Override
        public boolean canUndo() {
            return true;
        }

        @Override
        public void undo() {
            SEEDS.remove(this.entry);
        }

        @Override
        public String describe() {
            return "Adding seed entry " + this.item;
        }

        @Override
        public String describeUndo() {
            return "Removing seed entry " + this.item;
        }

        @Override
        public Object getOverrideKey() {
            return null;
        }
    }
}

