/*
 * Decompiled with CFR 0.152.
 */
package minetweaker.mods.jei;

import java.util.ArrayList;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import minetweaker.api.minecraft.MineTweakerMC;
import minetweaker.mc1112.recipes.MCRecipeManager;
import minetweaker.mods.jei.JEIAddonPlugin;
import minetweaker.mods.jei.network.MessageJEIHide;
import minetweaker.mods.jei.network.PacketHandler;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.jei.JEI")
public class JEI {
    @ZenMethod
    public static void hide(IItemStack stack) {
        MineTweakerAPI.apply(new Hide(MineTweakerMC.getItemStack(stack)));
    }

    @ZenMethod
    public static void removeAndHide(IIngredient output, @Optional boolean nbtMatch) {
        ArrayList<IRecipe> toRemove = new ArrayList<IRecipe>();
        ArrayList<Integer> removeIndex = new ArrayList<Integer>();
        for (int i = 0; i < MCRecipeManager.recipes.size(); ++i) {
            IRecipe recipe = MCRecipeManager.recipes.get(i);
            if (recipe.func_77571_b().func_190926_b() || !(nbtMatch ? output.matchesExact(MineTweakerMC.getIItemStack(recipe.func_77571_b())) : output.matches(MineTweakerMC.getIItemStack(recipe.func_77571_b())))) continue;
            toRemove.add(recipe);
            removeIndex.add(i);
        }
        MineTweakerAPI.apply(new MCRecipeManager.ActionRemoveRecipes(toRemove, removeIndex));
        for (IItemStack stack : output.getItems()) {
            MineTweakerAPI.apply(new Hide(MineTweakerMC.getItemStack(stack)));
        }
    }

    private static class Hide
    implements IUndoableAction {
        private ItemStack stack;

        public Hide(ItemStack stack) {
            this.stack = stack;
        }

        @Override
        public void apply() {
            if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
                PacketHandler.INSTANCE.sendToAll((IMessage)new MessageJEIHide(true, this.stack));
            } else {
                JEIAddonPlugin.itemRegistry.removeIngredientsAtRuntime(ItemStack.class, JEIAddonPlugin.getSubTypes(this.stack));
            }
        }

        @Override
        public boolean canUndo() {
            return true;
        }

        @Override
        public void undo() {
            if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
                PacketHandler.INSTANCE.sendToAll((IMessage)new MessageJEIHide(false, this.stack));
            } else {
                JEIAddonPlugin.itemRegistry.addIngredientsAtRuntime(ItemStack.class, JEIAddonPlugin.getSubTypes(this.stack));
            }
        }

        @Override
        public String describe() {
            return "Hiding item in JEI: " + this.stack;
        }

        @Override
        public String describeUndo() {
            return "Displaying item in JEI: " + this.stack;
        }

        @Override
        public Object getOverrideKey() {
            return null;
        }
    }
}

