/*
 * Decompiled with CFR 0.152.
 */
package minetweaker.mods.jei;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.IRecipeRegistry;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeWrapper;
import mezz.jei.ingredients.IngredientInformation;
import mezz.jei.plugins.vanilla.furnace.FuelRecipe;
import mezz.jei.plugins.vanilla.furnace.SmeltingRecipe;
import minetweaker.api.compat.IJEIRecipeRegistry;
import minetweaker.api.item.IIngredient;
import minetweaker.mc1112.util.MineTweakerHacks;
import minetweaker.mods.jei.JEIAddonPlugin;
import minetweaker.mods.jei.network.MessageJEIHide;
import minetweaker.mods.jei.network.PacketHandler;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;

public class JEIRecipeRegistry
implements IJEIRecipeRegistry {
    private IRecipeRegistry recipeRegistry;
    private IJeiHelpers jeiHelpers;
    private static Map<String, List<String>> TOOLTIP_CACHE;

    public JEIRecipeRegistry(IRecipeRegistry recipeRegistry, IJeiHelpers jeiHelpers) {
        this.recipeRegistry = recipeRegistry;
        this.jeiHelpers = jeiHelpers;
    }

    @Override
    public void addRecipe(Object object) {
        this.recipeRegistry.addRecipe(object);
    }

    @Override
    public void addRecipe(Object object, String category) {
        if (this.recipeRegistry.getRecipeWrapper(object, category) != null) {
            this.recipeRegistry.addRecipe(this.recipeRegistry.getRecipeWrapper(object, category), category);
        }
    }

    @Override
    public void removeRecipe(Object object) {
        this.recipeRegistry.removeRecipe(object);
    }

    @Override
    public void removeRecipe(Object output, String category) {
        if (this.recipeRegistry.getRecipeWrapper(output, category) != null) {
            this.recipeRegistry.removeRecipe(this.recipeRegistry.getRecipeWrapper(output, category), category);
        }
    }

    @Override
    public void addFurnace(List<Object> input, Object output) {
        ArrayList inputs = new ArrayList();
        input.forEach(in -> inputs.add((ItemStack)in));
        this.recipeRegistry.addRecipe((IRecipeWrapper)new SmeltingRecipe(inputs, (ItemStack)output), "minecraft.smelting");
    }

    @Override
    public void removeFurnace(Object object) {
        List<ItemStack> stacks = JEIAddonPlugin.getSubTypes((ItemStack)object);
        for (ItemStack itemStack : stacks) {
            IFocus focus = this.recipeRegistry.createFocus(IFocus.Mode.INPUT, (Object)itemStack);
            List categories = this.recipeRegistry.getRecipeCategories(Collections.singletonList("minecraft.smelting"));
            for (IRecipeCategory category : categories) {
                if (!category.getUid().equals("minecraft.smelting")) continue;
                List wrappers = this.recipeRegistry.getRecipeWrappers(category, focus);
                for (IRecipeWrapper wrapper : wrappers) {
                    this.recipeRegistry.removeRecipe(wrapper, "minecraft.smelting");
                }
            }
        }
    }

    @Override
    public void addFuel(Collection<Object> input, int burnTime) {
        ArrayList inputs = new ArrayList();
        input.forEach(in -> inputs.add((ItemStack)in));
        this.recipeRegistry.addRecipe((IRecipeWrapper)new FuelRecipe(this.jeiHelpers.getGuiHelper(), inputs, burnTime), "minecraft.fuel");
    }

    @Override
    public void removeFuel(Object object) {
        IFocus focus = this.recipeRegistry.createFocus(IFocus.Mode.INPUT, (Object)((ItemStack)object));
        List categories = this.recipeRegistry.getRecipeCategories(focus);
        for (IRecipeCategory category : categories) {
            if (!category.getUid().equals("minecraft.fuel")) continue;
            List wrappers = this.recipeRegistry.getRecipeWrappers(category, focus);
            for (IRecipeWrapper wrapper : wrappers) {
                this.recipeRegistry.removeRecipe(wrapper, "minecraft.smelting");
            }
        }
    }

    @Override
    public void reloadItemList() {
    }

    @Override
    public void removeItem(Object stack) {
        if (FMLCommonHandler.instance().getSide() == Side.SERVER) {
            PacketHandler.INSTANCE.sendToAll((IMessage)new MessageJEIHide(true, (ItemStack)stack));
        } else {
            JEIAddonPlugin.itemRegistry.removeIngredientsAtRuntime(ItemStack.class, JEIAddonPlugin.getSubTypes((ItemStack)stack));
        }
    }

    @Override
    public void addItem(Object stack) {
        if (FMLCommonHandler.instance().getSide() == Side.SERVER) {
            PacketHandler.INSTANCE.sendToAll((IMessage)new MessageJEIHide(false, (ItemStack)stack));
        } else {
            JEIAddonPlugin.itemRegistry.addIngredientsAtRuntime(ItemStack.class, JEIAddonPlugin.getSubTypes((ItemStack)stack));
        }
    }

    @Override
    public void invalidateTooltips(IIngredient ingredient) {
        if (TOOLTIP_CACHE == null) {
            TOOLTIP_CACHE = (Map)MineTweakerHacks.getPrivateStaticObject(IngredientInformation.class, "TOOLTIP_CACHE");
        }
        if (TOOLTIP_CACHE != null) {
            TOOLTIP_CACHE.clear();
            this.removeItem(ingredient.getInternal());
            this.addItem(ingredient.getInternal());
        }
    }
}

