/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.block.material;

import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker.api.brackets.CommandStringDisplayable;
import com.blamejared.crafttweaker.impl.block.material.MCMaterialColor;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import com.blamejared.crafttweaker_annotations.annotations.ZenWrapper;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.material.Material;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="crafttweaker.api.block.material.MCMaterial")
@Document(value="vanilla/api/block/material/MCMaterial")
@ZenWrapper(wrappedClass="net.minecraft.block.material.Material", displayStringFormat="%s.toString()", creationMethodFormat="new MCMaterial(%s, \"unknown\")")
public class MCMaterial
implements CommandStringDisplayable {
    private static final Map<String, MCMaterial> hardcodedMaterials = new HashMap<String, MCMaterial>();
    private final Material internal;
    private final String name;

    public MCMaterial(Material internal, String name) {
        this.internal = internal;
        this.name = name;
    }

    public static MCMaterial tryGet(String tokens) {
        return hardcodedMaterials.get(tokens.toUpperCase());
    }

    public Material getInternal() {
        return this.internal;
    }

    @ZenCodeType.Method
    public boolean isOpaque() {
        return this.internal.func_76218_k();
    }

    @ZenCodeType.Method
    public MCMaterialColor getColor() {
        return new MCMaterialColor(this.internal.func_151565_r());
    }

    @ZenCodeType.Method
    public boolean isSolid() {
        return this.internal.func_76220_a();
    }

    @ZenCodeType.Method
    public boolean isFlammable() {
        return this.internal.func_76217_h();
    }

    @ZenCodeType.Method
    public boolean isLiquid() {
        return this.internal.func_76224_d();
    }

    @ZenCodeType.Method
    public boolean isToolNotRequired() {
        return this.internal.func_76229_l();
    }

    @ZenCodeType.Method
    public boolean isReplaceable() {
        return this.internal.func_76222_j();
    }

    @ZenCodeType.Method
    public boolean blocksMovement() {
        return this.internal.func_76230_c();
    }

    @Override
    public String getCommandString() {
        return "<blockmaterial:" + this.getName() + ">";
    }

    public String getName() {
        return this.name;
    }

    static {
        hardcodedMaterials.put("AIR", new MCMaterial(Material.field_151579_a, "AIR"));
        hardcodedMaterials.put("STRUCTURE_VOID", new MCMaterial(Material.field_189963_J, "STRUCTURE_VOID"));
        hardcodedMaterials.put("PORTAL", new MCMaterial(Material.field_151567_E, "PORTAL"));
        hardcodedMaterials.put("CARPET", new MCMaterial(Material.field_151593_r, "CARPET"));
        hardcodedMaterials.put("PLANTS", new MCMaterial(Material.field_151585_k, "PLANTS"));
        hardcodedMaterials.put("OCEAN_PLANT", new MCMaterial(Material.field_203243_f, "OCEAN_PLANT"));
        hardcodedMaterials.put("TALL_PLANTS", new MCMaterial(Material.field_151582_l, "TALL_PLANTS"));
        hardcodedMaterials.put("SEA_GRASS", new MCMaterial(Material.field_204868_h, "SEA_GRASS"));
        hardcodedMaterials.put("WATER", new MCMaterial(Material.field_151586_h, "WATER"));
        hardcodedMaterials.put("BUBBLE_COLUMN", new MCMaterial(Material.field_203244_i, "BUBBLE_COLUMN"));
        hardcodedMaterials.put("LAVA", new MCMaterial(Material.field_151587_i, "LAVA"));
        hardcodedMaterials.put("SNOW", new MCMaterial(Material.field_151597_y, "SNOW"));
        hardcodedMaterials.put("FIRE", new MCMaterial(Material.field_151581_o, "FIRE"));
        hardcodedMaterials.put("MISCELLANEOUS", new MCMaterial(Material.field_151594_q, "MISCELLANEOUS"));
        hardcodedMaterials.put("WEB", new MCMaterial(Material.field_151569_G, "WEB"));
        hardcodedMaterials.put("REDSTONE_LIGHT", new MCMaterial(Material.field_151591_t, "REDSTONE_LIGHT"));
        hardcodedMaterials.put("CLAY", new MCMaterial(Material.field_151571_B, "CLAY"));
        hardcodedMaterials.put("EARTH", new MCMaterial(Material.field_151578_c, "EARTH"));
        hardcodedMaterials.put("ORGANIC", new MCMaterial(Material.field_151577_b, "ORGANIC"));
        hardcodedMaterials.put("PACKED_ICE", new MCMaterial(Material.field_151598_x, "PACKED_ICE"));
        hardcodedMaterials.put("SAND", new MCMaterial(Material.field_151595_p, "SAND"));
        hardcodedMaterials.put("SPONGE", new MCMaterial(Material.field_151583_m, "SPONGE"));
        hardcodedMaterials.put("SHULKER", new MCMaterial(Material.field_215711_w, "SHULKER"));
        hardcodedMaterials.put("WOOD", new MCMaterial(Material.field_151575_d, "WOOD"));
        hardcodedMaterials.put("BAMBOO_SAPLING", new MCMaterial(Material.field_215712_y, "BAMBOO_SAPLING"));
        hardcodedMaterials.put("BAMBOO", new MCMaterial(Material.field_215713_z, "BAMBOO"));
        hardcodedMaterials.put("WOOL", new MCMaterial(Material.field_151580_n, "WOOL"));
        hardcodedMaterials.put("TNT", new MCMaterial(Material.field_151590_u, "TNT"));
        hardcodedMaterials.put("LEAVES", new MCMaterial(Material.field_151584_j, "LEAVES"));
        hardcodedMaterials.put("GLASS", new MCMaterial(Material.field_151592_s, "GLASS"));
        hardcodedMaterials.put("ICE", new MCMaterial(Material.field_151588_w, "ICE"));
        hardcodedMaterials.put("CACTUS", new MCMaterial(Material.field_151570_A, "CACTUS"));
        hardcodedMaterials.put("ROCK", new MCMaterial(Material.field_151576_e, "ROCK"));
        hardcodedMaterials.put("IRON", new MCMaterial(Material.field_151573_f, "IRON"));
        hardcodedMaterials.put("SNOW_BLOCK", new MCMaterial(Material.field_151596_z, "SNOW_BLOCK"));
        hardcodedMaterials.put("ANVIL", new MCMaterial(Material.field_151574_g, "ANVIL"));
        hardcodedMaterials.put("BARRIER", new MCMaterial(Material.field_175972_I, "BARRIER"));
        hardcodedMaterials.put("PISTON", new MCMaterial(Material.field_76233_E, "PISTON"));
        hardcodedMaterials.put("CORAL", new MCMaterial(Material.field_151589_v, "CORAL"));
        hardcodedMaterials.put("GOURD", new MCMaterial(Material.field_151572_C, "GOURD"));
        hardcodedMaterials.put("DRAGON_EGG", new MCMaterial(Material.field_151566_D, "DRAGON_EGG"));
        hardcodedMaterials.put("CAKE", new MCMaterial(Material.field_151568_F, "CAKE"));
    }
}

