/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.blocks;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker.api.brackets.CommandStringDisplayable;
import com.blamejared.crafttweaker.impl.blocks.MCBlock;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import com.blamejared.crafttweaker_annotations.annotations.ZenWrapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.block.BlockState;
import net.minecraft.state.IProperty;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="crafttweaker.api.block.MCBlockState")
@Document(value="vanilla/api/blocks/MCBlockState")
@ZenWrapper(wrappedClass="net.minecraft.block.BlockState", conversionMethodFormat="%s.getInternal()", displayStringFormat="%s.getCommandString()")
public class MCBlockState
implements CommandStringDisplayable {
    private final BlockState internal;
    private final MCBlock internalBlock;

    public MCBlockState(BlockState internal) {
        this.internal = internal;
        this.internalBlock = new MCBlock(internal.func_177230_c());
    }

    @ZenCodeType.Getter(value="block")
    public MCBlock getBlock() {
        return this.getInternalBlock();
    }

    @ZenCodeType.Getter(value="lightLevel")
    public int getLightLevel() {
        return this.getInternal().func_185906_d();
    }

    @ZenCodeType.Getter(value="canProvidePower")
    public boolean canProvidePower() {
        return this.getInternal().func_185897_m();
    }

    @ZenCodeType.Getter(value="isSolid")
    public boolean isSolid() {
        return this.getInternal().func_200132_m();
    }

    @ZenCodeType.Getter(value="ticksRandomly")
    public boolean ticksRandomly() {
        return this.getInternal().func_204519_t();
    }

    @ZenCodeType.Getter(value="hasTileEntity")
    public boolean hasTileEntity() {
        return this.getInternal().hasTileEntity();
    }

    @ZenCodeType.Getter(value="isSticky")
    public boolean isSticky() {
        return this.getInternal().isStickyBlock();
    }

    @ZenCodeType.Method
    public MCBlockState withProperty(String name, String value) {
        IProperty property = this.getInternal().func_177230_c().func_176194_O().func_185920_a(name);
        if (property == null) {
            CraftTweakerAPI.logWarning("Invalid property name", new Object[0]);
        } else {
            Optional propValue = property.func_185929_b(value);
            if (propValue.isPresent()) {
                return new MCBlockState((BlockState)this.getInternal().func_206870_a(property, (Comparable)propValue.get()));
            }
            CraftTweakerAPI.logWarning("Invalid property value", new Object[0]);
        }
        return this;
    }

    @ZenCodeType.Method
    public List<String> getPropertyNames() {
        ArrayList<String> props = new ArrayList<String>();
        for (IProperty prop : this.getInternal().func_206869_a()) {
            props.add(prop.func_177701_a());
        }
        return ImmutableList.copyOf(props);
    }

    @ZenCodeType.Method
    public String getPropertyValue(String name) {
        IProperty prop = this.getInternal().func_177230_c().func_176194_O().func_185920_a(name);
        if (prop != null) {
            return this.getInternal().func_177229_b(prop).toString();
        }
        CraftTweakerAPI.logWarning("Invalid property name", new Object[0]);
        return "";
    }

    @ZenCodeType.Method
    public List<String> getAllowedValuesForProperty(String name) {
        IProperty prop = this.getInternal().func_177230_c().func_176194_O().func_185920_a(name);
        if (prop != null) {
            ArrayList<String> values = new ArrayList<String>();
            prop.func_177700_c().forEach(v -> values.add(v.toString()));
            return values;
        }
        CraftTweakerAPI.logWarning("Invalid property name", new Object[0]);
        return ImmutableList.of();
    }

    @ZenCodeType.Method
    public Map<String, String> getProperties() {
        HashMap<String, String> props = new HashMap<String, String>();
        for (IProperty key : this.getInternal().func_206869_a()) {
            props.put(key.func_177701_a(), this.getInternal().func_177229_b(key).toString());
        }
        return ImmutableMap.copyOf(props);
    }

    @ZenCodeType.Method
    public boolean hasProperty(String name) {
        IProperty prop = this.getInternal().func_177230_c().func_176194_O().func_185920_a(name);
        return prop != null;
    }

    @ZenCodeType.Caster(implicit=false)
    public String asString() {
        return this.internal.toString();
    }

    @ZenCodeType.Caster(implicit=true)
    public MCBlock asBlock() {
        return this.getInternalBlock();
    }

    @Override
    @ZenCodeType.Getter(value="commandString")
    public String getCommandString() {
        StringBuilder builder = new StringBuilder("<blockstate:");
        builder.append(this.getBlock().getInternal().getRegistryName().toString());
        if (!this.getProperties().isEmpty()) {
            builder.append(":");
            builder.append(this.getProperties().entrySet().stream().map(kv -> (String)kv.getKey() + "=" + (String)kv.getValue()).collect(Collectors.joining(",")));
        }
        builder.append(">");
        return builder.toString();
    }

    public BlockState getInternal() {
        return this.internal;
    }

    public MCBlock getInternalBlock() {
        return this.internalBlock;
    }
}

