/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.fluid;

import com.blamejared.crafttweaker.api.fluid.IFluidStack;
import com.blamejared.crafttweaker.impl.fluid.MCFluid;
import com.blamejared.crafttweaker.impl.fluid.MCFluidStackMutable;
import net.minecraft.fluid.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class MCFluidStack
implements IFluidStack {
    private final FluidStack stack;

    public MCFluidStack(FluidStack fluidStack) {
        this.stack = fluidStack;
    }

    @Override
    public String getCommandString() {
        Fluid fluid = this.stack.getFluid();
        StringBuilder builder = new StringBuilder().append("<fluid:").append(fluid.getRegistryName()).append(">");
        if (this.stack.getAmount() != 1) {
            builder.append(" * ").append(this.stack.getAmount());
        }
        return builder.toString();
    }

    @Override
    public IFluidStack setAmount(int amount) {
        FluidStack copy = this.stack.copy();
        copy.setAmount(amount);
        return new MCFluidStack(copy);
    }

    @Override
    public IFluidStack multiply(int amount) {
        return this.setAmount(amount);
    }

    @Override
    public IFluidStack mutable() {
        return new MCFluidStackMutable(this.stack);
    }

    @Override
    public IFluidStack copy() {
        return new MCFluidStack(this.stack.copy());
    }

    @Override
    public MCFluid getFluid() {
        return new MCFluid(this.stack.getFluid());
    }

    @Override
    public FluidStack getInternal() {
        return this.stack;
    }
}

