/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.fluid;

import com.blamejared.crafttweaker.api.fluid.IFluidStack;
import com.blamejared.crafttweaker.impl.fluid.MCFluid;
import net.minecraft.fluid.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class MCFluidStackMutable
implements IFluidStack {
    private final FluidStack stack;

    public MCFluidStackMutable(FluidStack stack) {
        this.stack = stack;
    }

    @Override
    public IFluidStack setAmount(int amount) {
        return this.multiply(amount);
    }

    @Override
    public IFluidStack multiply(int amount) {
        this.stack.setAmount(amount);
        return this;
    }

    @Override
    public IFluidStack mutable() {
        return this;
    }

    @Override
    public MCFluid getFluid() {
        return new MCFluid(this.stack.getFluid());
    }

    @Override
    public IFluidStack copy() {
        return new MCFluidStackMutable(this.stack.copy());
    }

    @Override
    public FluidStack getInternal() {
        return this.stack;
    }

    @Override
    public String getCommandString() {
        Fluid fluid = this.stack.getFluid();
        StringBuilder stringBuilder = new StringBuilder("<fluid:");
        stringBuilder.append(fluid.getRegistryName());
        stringBuilder.append(">.mutable()");
        if (this.stack.getAmount() != 1) {
            stringBuilder.append(" * ");
            stringBuilder.append(this.stack.getAmount());
        }
        return stringBuilder.toString();
    }
}

