/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.ingredients.conditions;

import com.blamejared.crafttweaker.CraftTweakerRegistries;
import com.blamejared.crafttweaker.api.item.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.item.conditions.IIngredientCondition;
import com.blamejared.crafttweaker.api.item.conditions.IIngredientConditionSerializer;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;

public class ConditionCustom<T extends IIngredient>
implements IIngredientCondition<T> {
    public static final Map<String, Predicate<IItemStack>> knownConditions = new HashMap<String, Predicate<IItemStack>>();
    private final String uid;
    private Predicate<IItemStack> function;

    public ConditionCustom(String uid, Predicate<IItemStack> function) {
        this.uid = uid;
        this.function = function;
        if (function != null) {
            knownConditions.put(uid, function);
        }
    }

    @Override
    public boolean matches(IItemStack stack) {
        if (this.function == null) {
            this.function = knownConditions.get(this.uid);
        }
        if (this.function == null) {
            throw new IllegalStateException("No condition named '" + this.uid + "' known!");
        }
        return this.function.test(stack);
    }

    @Override
    public String getCommandString(T ingredient) {
        return String.format("%s.onlyIf('%s')", ingredient.getCommandString(), this.uid);
    }

    @Override
    public boolean ignoresDamage() {
        return true;
    }

    @Override
    public IIngredientConditionSerializer getSerializer() {
        return CraftTweakerRegistries.CONDITION_CUSTOM_SERIALIZER;
    }

    public static final class ConditionCustomSerializer
    implements IIngredientConditionSerializer<ConditionCustom<?>> {
        @Override
        public ConditionCustom<?> parse(PacketBuffer buffer) {
            return new ConditionCustom(buffer.func_218666_n(), null);
        }

        @Override
        public ConditionCustom<?> parse(JsonObject json) {
            String uid = json.getAsJsonPrimitive("uid").getAsString();
            return new ConditionCustom(uid, null);
        }

        @Override
        public void write(PacketBuffer buffer, ConditionCustom<?> ingredient) {
            buffer.func_180714_a(((ConditionCustom)ingredient).uid);
        }

        @Override
        public JsonObject toJson(ConditionCustom<?> transformer) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("uid", ((ConditionCustom)transformer).uid);
            return jsonObject;
        }

        @Override
        public ResourceLocation getType() {
            return new ResourceLocation("crafttweaker", "condition_custom");
        }
    }
}

