/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.item.conditions;

import com.blamejared.crafttweaker.CraftTweakerRegistries;
import com.blamejared.crafttweaker.api.item.IIngredient;
import com.blamejared.crafttweaker.api.item.conditions.IIngredientCondition;
import com.blamejared.crafttweaker.api.item.conditions.IIngredientConditionSerializer;
import com.blamejared.crafttweaker.impl.item.conditions.IngredientConditioned;
import com.blamejared.crafttweaker.impl.item.conditions.MCIngredientConditioned;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class IngredientConditionedSerializer
implements IIngredientSerializer<IngredientConditioned<?, ?>> {
    public JsonObject toJson(IngredientConditioned<?, ?> ingredientVanillaPlus) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.add("base", ((MCIngredientConditioned)ingredientVanillaPlus.getCrTIngredient()).getBaseIngredient().asVanillaIngredient().func_200304_c());
        IIngredientCondition<?> condition = ingredientVanillaPlus.getCondition();
        JsonObject value = condition.toJson();
        if (!value.has("type")) {
            value.addProperty("type", condition.getType().toString());
        }
        jsonObject.add("condition", (JsonElement)value);
        return jsonObject;
    }

    public IngredientConditioned<?, ?> parse(PacketBuffer buffer) {
        IIngredient base = IIngredient.fromIngredient(Ingredient.func_199566_b((PacketBuffer)buffer));
        ResourceLocation type = buffer.func_192575_l();
        Optional value = CraftTweakerRegistries.REGISTRY_CONDITIONER_SERIALIZER.func_218349_b(type);
        if (!value.isPresent()) {
            throw new IllegalArgumentException("Invalid type: " + type);
        }
        return new IngredientConditioned(new MCIngredientConditioned<IIngredient>(base, (IIngredientCondition<IIngredient>)((IIngredientConditionSerializer)value.get()).parse(buffer)));
    }

    public IngredientConditioned<?, ?> parse(JsonObject json) {
        JsonObject base = json.getAsJsonObject("base");
        IIngredient baseIngredient = IIngredient.fromIngredient(CraftingHelper.getIngredient((JsonElement)base));
        JsonObject condition = json.getAsJsonObject("condition");
        ResourceLocation type = new ResourceLocation(condition.get("type").getAsString());
        Optional value = CraftTweakerRegistries.REGISTRY_CONDITIONER_SERIALIZER.func_218349_b(type);
        if (!value.isPresent()) {
            throw new IllegalArgumentException("Invalid type: " + type);
        }
        return new IngredientConditioned(new MCIngredientConditioned<IIngredient>(baseIngredient, (IIngredientCondition<IIngredient>)((IIngredientConditionSerializer)value.get()).parse(condition)));
    }

    public void write(PacketBuffer buffer, IngredientConditioned<?, ?> ingredient) {
        Ingredient baseIngredient = ((MCIngredientConditioned)ingredient.getCrTIngredient()).getBaseIngredient().asVanillaIngredient();
        baseIngredient.func_199564_a(buffer);
        IIngredientCondition<?> condition = ingredient.getCondition();
        IIngredientConditionSerializer serializer = condition.getSerializer();
        buffer.func_192572_a(serializer.getType());
        condition.write(buffer);
    }
}

