/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.recipes;

import com.blamejared.crafttweaker.api.item.IIngredient;
import com.blamejared.crafttweaker.impl.item.MCItemStack;
import com.blamejared.crafttweaker.impl.recipes.CTRecipeShapeless;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistryEntry;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class SerializerShapeless
extends ForgeRegistryEntry<IRecipeSerializer<?>>
implements IRecipeSerializer<CTRecipeShapeless> {
    private static NonNullList<Ingredient> readIngredients(JsonArray p_199568_0_) {
        NonNullList nonnulllist = NonNullList.func_191196_a();
        for (int i = 0; i < p_199568_0_.size(); ++i) {
            Ingredient ingredient = Ingredient.func_199802_a((JsonElement)p_199568_0_.get(i));
            if (ingredient.func_203189_d()) continue;
            nonnulllist.add((Object)ingredient);
        }
        return nonnulllist;
    }

    public CTRecipeShapeless read(ResourceLocation recipeId, JsonObject json) {
        NonNullList<Ingredient> nonnulllist = SerializerShapeless.readIngredients(JSONUtils.func_151214_t((JsonObject)json, (String)"ingredients"));
        IIngredient[] ingredients = new IIngredient[nonnulllist.size()];
        for (int i = 0; i < nonnulllist.size(); ++i) {
            ingredients[i] = IIngredient.fromIngredient((Ingredient)nonnulllist.get(i));
        }
        if (nonnulllist.isEmpty()) {
            throw new JsonParseException("No ingredients for shapeless recipe");
        }
        if (nonnulllist.size() > 9) {
            throw new JsonParseException("Too many ingredients for shapeless recipe the max is 9");
        }
        ItemStack itemstack = ShapedRecipe.func_199798_a((JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)"result"));
        return new CTRecipeShapeless(recipeId.func_110623_a(), new MCItemStack(itemstack), ingredients, null);
    }

    public CTRecipeShapeless read(ResourceLocation recipeId, PacketBuffer buffer) {
        int i = buffer.func_150792_a();
        IIngredient[] ingredients = new IIngredient[i];
        for (int j = 0; j < ingredients.length; ++j) {
            ingredients[j] = IIngredient.fromIngredient(Ingredient.func_199566_b((PacketBuffer)buffer));
        }
        ItemStack itemstack = buffer.func_150791_c();
        return new CTRecipeShapeless(recipeId.func_110623_a(), new MCItemStack(itemstack), ingredients, null);
    }

    public void write(PacketBuffer buffer, CTRecipeShapeless recipe) {
        buffer.func_150787_b(recipe.func_192400_c().size());
        for (Ingredient ingredient : recipe.func_192400_c()) {
            ingredient.func_199564_a(buffer);
        }
        buffer.func_150788_a(recipe.func_77571_b());
    }
}

