/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.tag;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker.api.item.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.impl.actions.tags.ActionTagAdd;
import com.blamejared.crafttweaker.impl.actions.tags.ActionTagCreate;
import com.blamejared.crafttweaker.impl.actions.tags.ActionTagRemove;
import com.blamejared.crafttweaker.impl.blocks.MCBlock;
import com.blamejared.crafttweaker.impl.entity.MCEntityType;
import com.blamejared.crafttweaker.impl.fluid.MCFluid;
import com.blamejared.crafttweaker.impl.helper.CraftTweakerHelper;
import com.blamejared.crafttweaker.impl.item.MCItemStack;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import com.blamejared.crafttweaker_annotations.annotations.ZenWrapper;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityType;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistryEntry;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="crafttweaker.api.tag.MCTag")
@Document(value="vanilla/api/tags/MCTag")
@ZenWrapper(wrappedClass="net.minecraft.tags.Tag", conversionMethodFormat="%s.getInternal()", displayStringFormat="%s.getCommandString()")
public class MCTag
implements IIngredient {
    private final ResourceLocation id;
    private Tag<Item> itemTag;
    private Tag<Block> blockTag;
    private Tag<EntityType<?>> entityTypeTag;
    private Tag<Fluid> fluidTag;

    public MCTag(ResourceLocation id) {
        this.id = id;
    }

    @ZenCodeType.Method
    public MCTag createItemTag() {
        CraftTweakerAPI.apply(new ActionTagCreate(ItemTags.func_199903_a(), "Item", new Tag(this.id, (Collection)Sets.newHashSet(), false)));
        return this;
    }

    @ZenCodeType.Method
    public MCTag createBlockTag() {
        CraftTweakerAPI.apply(new ActionTagCreate(BlockTags.func_199896_a(), "Block", new Tag(this.id, (Collection)Sets.newHashSet(), false)));
        return this;
    }

    @ZenCodeType.Method
    public MCTag createFluidTag() {
        CraftTweakerAPI.apply(new ActionTagCreate(FluidTags.getCollection(), "Fluid", new Tag(this.id, (Collection)Sets.newHashSet(), false)));
        return this;
    }

    @ZenCodeType.Method
    public MCTag createEntityTypeTag() {
        CraftTweakerAPI.apply(new ActionTagCreate(EntityTypeTags.func_219762_a(), "EntityType", new Tag(this.id, (Collection)Sets.newHashSet(), false)));
        return this;
    }

    @Override
    public IItemStack[] getItems() {
        if (this.getItemTag() == null) {
            CraftTweakerAPI.logError("\"" + this.getCommandString() + "\" is not an ItemTag!", new Object[0]);
            return new IItemStack[0];
        }
        ArrayList<MCItemStack> returned = new ArrayList<MCItemStack>();
        for (Item element : this.itemTag.func_199885_a()) {
            returned.add(new MCItemStack(new ItemStack((IItemProvider)element)));
        }
        return returned.toArray(new IItemStack[0]);
    }

    @ZenCodeType.Getter(value="blocks")
    public MCBlock[] getBlocks() {
        if (this.getBlockTag() == null) {
            CraftTweakerAPI.logError("\"" + this.getCommandString() + "\" is not a BlockTag!", new Object[0]);
            return new MCBlock[0];
        }
        ArrayList<MCBlock> returned = new ArrayList<MCBlock>();
        for (Block element : this.blockTag.func_199885_a()) {
            returned.add(new MCBlock(element));
        }
        return returned.toArray(new MCBlock[0]);
    }

    @ZenCodeType.Getter(value="fluids")
    public MCFluid[] getFluids() {
        if (this.getFluidTag() == null) {
            CraftTweakerAPI.logError("\"" + this.getCommandString() + "\" is not a BlockTag!", new Object[0]);
            return new MCFluid[0];
        }
        return (MCFluid[])this.getFluidTag().func_199885_a().stream().map(MCFluid::new).toArray(MCFluid[]::new);
    }

    @ZenCodeType.Getter(value="entityTypes")
    public MCEntityType[] getEntityTypes() {
        if (this.getEntityTypeTag() == null) {
            CraftTweakerAPI.logError("\"" + this.getCommandString() + "\" is not an EntityTypeTag!", new Object[0]);
            return new MCEntityType[0];
        }
        ArrayList<MCEntityType> returned = new ArrayList<MCEntityType>();
        for (EntityType element : this.entityTypeTag.func_199885_a()) {
            returned.add(new MCEntityType(element));
        }
        return returned.toArray(new MCEntityType[0]);
    }

    @ZenCodeType.Getter(value="firstItem")
    public IItemStack getFirstItem() {
        if (this.getItemTag() == null) {
            throw new IllegalArgumentException("\"" + this.getCommandString() + "\" is not an ItemTag!");
        }
        return this.getItems()[0];
    }

    @ZenCodeType.Getter(value="firstBlock")
    public MCBlock getFirstBlock() {
        if (this.getBlockTag() == null) {
            throw new IllegalArgumentException("\"" + this.getCommandString() + "\" is not a BlockTag!");
        }
        return this.getBlocks()[0];
    }

    @ZenCodeType.Getter(value="firstFluid")
    public MCFluid getFirstFluid() {
        if (this.getFluidTag() == null) {
            throw new IllegalArgumentException("\"" + this.getCommandString() + "\" is not a FluidTag!");
        }
        return this.getFluids()[0];
    }

    @ZenCodeType.Getter(value="firstEntityType")
    public MCEntityType getFirstEntityType() {
        if (this.getEntityTypeTag() == null) {
            throw new IllegalArgumentException("\"" + this.getCommandString() + "\" is not an EntityTypeTag!");
        }
        return this.getEntityTypes()[0];
    }

    @ZenCodeType.Method
    public void addItems(IItemStack ... items) {
        CraftTweakerAPI.apply(new ActionTagAdd(this.getItemTag(), (ForgeRegistryEntry[])CraftTweakerHelper.getItems(items)));
    }

    @ZenCodeType.Method
    public void removeItems(IItemStack ... items) {
        CraftTweakerAPI.apply(new ActionTagRemove(this.getItemTag(), (ForgeRegistryEntry[])CraftTweakerHelper.getItems(items)));
    }

    @ZenCodeType.Method
    public void addBlocks(MCBlock ... blocks) {
        CraftTweakerAPI.apply(new ActionTagAdd(this.getBlockTag(), (ForgeRegistryEntry[])CraftTweakerHelper.getBlocks(blocks)));
    }

    @ZenCodeType.Method
    public void removeBlocks(MCBlock ... blocks) {
        CraftTweakerAPI.apply(new ActionTagRemove(this.getBlockTag(), (ForgeRegistryEntry[])CraftTweakerHelper.getBlocks(blocks)));
    }

    @ZenCodeType.Method
    public void addFluids(MCFluid ... fluids) {
        CraftTweakerAPI.apply(new ActionTagAdd(this.getFluidTag(), (ForgeRegistryEntry[])CraftTweakerHelper.getFluids(fluids)));
    }

    @ZenCodeType.Method
    public void removeFluids(MCFluid ... fluids) {
        CraftTweakerAPI.apply(new ActionTagRemove(this.getFluidTag(), (ForgeRegistryEntry[])CraftTweakerHelper.getFluids(fluids)));
    }

    @ZenCodeType.Method
    public void addEntityTypes(MCEntityType ... entities) {
        CraftTweakerAPI.apply(new ActionTagAdd(this.getEntityTypeTag(), CraftTweakerHelper.getEntityTypes(entities)));
    }

    @ZenCodeType.Method
    public void removeEntityTypes(MCEntityType ... entities) {
        CraftTweakerAPI.apply(new ActionTagRemove(this.getEntityTypeTag(), CraftTweakerHelper.getEntityTypes(entities)));
    }

    @Override
    public boolean matches(IItemStack stack, boolean ignoreDamage) {
        if (!stack.isEmpty()) {
            for (IItemStack item : this.getItems()) {
                if (!item.matches(stack, ignoreDamage)) continue;
                return true;
            }
        }
        return false;
    }

    @ZenCodeType.Getter(value="isItemTag")
    public boolean isItemTag() {
        return this.getItemTag() != null;
    }

    @ZenCodeType.Getter(value="isBlockTag")
    public boolean isBlockTag() {
        return this.getBlockTag() != null;
    }

    @ZenCodeType.Getter(value="isEntityTypeTag")
    public boolean isEntityTypeTag() {
        return this.getEntityTypeTag() != null;
    }

    @Override
    public Ingredient asVanillaIngredient() {
        return Ingredient.func_199805_a(this.getItemTag());
    }

    public Tag<Item> getItemTag() {
        if (this.itemTag == null) {
            this.itemTag = ItemTags.func_199903_a().func_199910_a(this.id);
        }
        return this.itemTag;
    }

    public Tag<Block> getBlockTag() {
        if (this.blockTag == null) {
            this.blockTag = BlockTags.func_199896_a().func_199910_a(this.id);
        }
        return this.blockTag;
    }

    public Tag<Fluid> getFluidTag() {
        if (this.fluidTag == null) {
            this.fluidTag = FluidTags.getCollection().func_199910_a(this.id);
        }
        return this.fluidTag;
    }

    public Tag<EntityType<?>> getEntityTypeTag() {
        if (this.entityTypeTag == null) {
            this.entityTypeTag = EntityTypeTags.func_219762_a().func_199910_a(this.id);
        }
        return this.entityTypeTag;
    }

    @Override
    public String getCommandString() {
        return String.format("<tag:%s>", this.id);
    }

    public String toString() {
        return this.getCommandString();
    }
}

