/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zenscript.codemodel;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openzen.zencode.shared.logging.IZSLogger;
import org.openzen.zenscript.codemodel.FunctionParameter;
import org.openzen.zenscript.codemodel.HighLevelDefinition;
import org.openzen.zenscript.codemodel.Module;
import org.openzen.zenscript.codemodel.PackageDefinitions;
import org.openzen.zenscript.codemodel.ScriptBlock;
import org.openzen.zenscript.codemodel.annotations.AnnotationDefinition;
import org.openzen.zenscript.codemodel.annotations.AnnotationProcessor;
import org.openzen.zenscript.codemodel.context.ModuleContext;
import org.openzen.zenscript.codemodel.context.ModuleTypeResolutionContext;
import org.openzen.zenscript.codemodel.definition.ExpansionDefinition;
import org.openzen.zenscript.codemodel.definition.ZSPackage;
import org.openzen.zenscript.codemodel.scope.FileScope;
import org.openzen.zenscript.codemodel.type.GlobalTypeRegistry;
import org.openzen.zenscript.codemodel.type.ISymbol;
import org.openzen.zenscript.codemodel.type.storage.StorageType;

public class SemanticModule {
    public static final SemanticModule[] NONE = new SemanticModule[0];
    public final String name;
    public final SemanticModule[] dependencies;
    public final FunctionParameter[] parameters;
    public final State state;
    public final Module module;
    public final ZSPackage rootPackage;
    public final ZSPackage modulePackage;
    public final PackageDefinitions definitions;
    public final List<ScriptBlock> scripts;
    public final Map<String, ISymbol> globals = new HashMap<String, ISymbol>();
    public final GlobalTypeRegistry registry;
    public final List<ExpansionDefinition> expansions;
    public final AnnotationDefinition[] annotations;
    public final StorageType[] storageTypes;
    public final IZSLogger logger;

    public SemanticModule(Module module, SemanticModule[] dependencies, FunctionParameter[] parameters, State state, ZSPackage rootPackage, ZSPackage modulePackage, PackageDefinitions definitions, List<ScriptBlock> scripts, GlobalTypeRegistry registry, List<ExpansionDefinition> expansions, AnnotationDefinition[] annotations, StorageType[] storageTypes, IZSLogger logger) {
        this.name = module.name;
        this.module = module;
        this.dependencies = dependencies;
        this.parameters = parameters;
        this.state = state;
        this.rootPackage = rootPackage;
        this.modulePackage = modulePackage;
        this.definitions = definitions;
        this.scripts = scripts;
        this.registry = registry;
        this.expansions = expansions;
        this.annotations = annotations;
        this.storageTypes = storageTypes;
        this.logger = logger;
    }

    public boolean isValid() {
        return this.state != State.INVALID;
    }

    public SemanticModule normalize() {
        if (this.state != State.ASSEMBLED) {
            throw new IllegalStateException("Module is invalid");
        }
        ModuleTypeResolutionContext context = new ModuleTypeResolutionContext(this.registry, this.annotations, this.storageTypes, this.rootPackage, null, this.globals);
        AnnotationProcessor annotationProcessor = new AnnotationProcessor(context, this.expansions);
        ArrayList<ScriptBlock> processedScripts = new ArrayList<ScriptBlock>();
        FileScope fileScope = new FileScope(context, this.expansions, this.globals, member -> {});
        for (ScriptBlock block : this.scripts) {
            processedScripts.add(annotationProcessor.process(block).normalize(fileScope));
        }
        for (HighLevelDefinition definition : this.definitions.getAll()) {
            annotationProcessor.process(definition);
            definition.normalize(fileScope);
        }
        return new SemanticModule(this.module, this.dependencies, this.parameters, State.NORMALIZED, this.rootPackage, this.modulePackage, this.definitions, processedScripts, this.registry, this.expansions, this.annotations, this.storageTypes, this.logger);
    }

    public ModuleContext getContext() {
        return new ModuleContext(this.registry, this.module, this.expansions, this.rootPackage);
    }

    public static enum State {
        INVALID,
        ASSEMBLED,
        NORMALIZED,
        VALIDATED;

    }
}

