/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zenscript.codemodel.context;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.openzen.zencode.shared.CodePosition;
import org.openzen.zenscript.codemodel.GenericMapper;
import org.openzen.zenscript.codemodel.context.ModuleContext;
import org.openzen.zenscript.codemodel.generic.TypeParameter;
import org.openzen.zenscript.codemodel.type.StoredType;
import org.openzen.zenscript.codemodel.type.member.LocalMemberCache;
import org.openzen.zenscript.codemodel.type.member.TypeMembers;

public class TypeContext {
    protected final CodePosition position;
    protected final TypeParameter[] typeParameters;
    public final StoredType thisType;
    private final LocalMemberCache memberCache;
    public final ModuleContext moduleContext;

    public TypeContext(CodePosition position, ModuleContext context, TypeParameter[] parameters, StoredType thisType) {
        this.position = position;
        this.typeParameters = parameters;
        this.thisType = thisType;
        this.memberCache = new LocalMemberCache(context.registry, context.expansions);
        this.moduleContext = context;
    }

    public TypeContext(CodePosition position, TypeContext outer, StoredType thisType, TypeParameter ... inner) {
        this.position = position;
        this.typeParameters = TypeContext.concat(outer.typeParameters, inner);
        this.thisType = thisType;
        this.moduleContext = outer.moduleContext;
        this.memberCache = new LocalMemberCache(this.moduleContext.registry, this.moduleContext.expansions);
    }

    public TypeContext(CodePosition position, TypeContext outer, StoredType thisType, List<TypeParameter> inner) {
        this(position, outer, thisType, inner.toArray(new TypeParameter[inner.size()]));
    }

    public int getId(TypeParameter parameter) {
        for (int i = 0; i < this.typeParameters.length; ++i) {
            if (this.typeParameters[i] != parameter) continue;
            return i;
        }
        return -1;
    }

    public TypeParameter getTypeParameter(int index) {
        return this.typeParameters[index];
    }

    public TypeMembers getTypeMembers(StoredType type) {
        return this.memberCache.get(type);
    }

    public GenericMapper getMapper() {
        Map<TypeParameter, StoredType> mapper = StoredType.getSelfMapping(this.moduleContext.registry, this.typeParameters);
        return new GenericMapper(this.position, this.moduleContext.registry, mapper);
    }

    public static <T> T[] concat(T[] first, T[] second) {
        T[] result = Arrays.copyOf(first, first.length + second.length);
        System.arraycopy(second, 0, result, first.length, second.length);
        return result;
    }
}

