/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zenscript.lexer;

import java.util.ArrayList;
import java.util.Map;
import org.openzen.zenscript.lexer.NFA;
import org.openzen.zenscript.lexer.TokenType;

public class CompiledDFA<T> {
    public Map<Integer, Integer>[] transitions;
    public T[] finals;

    public static <T extends TokenType & Comparable<T>> CompiledDFA<T> createLexerDFA(T[] tokenTypes, Class<T> tokenClass) {
        ArrayList<T> tokens = new ArrayList<T>();
        ArrayList<String> regexps = new ArrayList<String>();
        for (T tokenType : tokenTypes) {
            if (tokenType.getRegexp() == null) continue;
            tokens.add(tokenType);
            regexps.add(tokenType.getRegexp());
        }
        return new NFA(regexps, tokens, tokenClass).compile();
    }

    public CompiledDFA(Map<Integer, Integer>[] transitions, T[] finals) {
        this.transitions = transitions;
        this.finals = finals;
    }

    public T eval(String value) {
        int state = 0;
        for (char c : value.toCharArray()) {
            if ((state = this.transitions[state].get(Character.valueOf(c)).intValue()) != Integer.MIN_VALUE) continue;
            return null;
        }
        return this.finals[state];
    }

    public boolean matches(String value) {
        return this.eval(value) != null;
    }

    public String toString() {
        int i;
        StringBuilder result = new StringBuilder();
        for (i = 0; i < this.transitions.length; ++i) {
            Map<Integer, Integer> map = this.transitions[i];
            for (int v : map.keySet()) {
                result.append("edge(");
                result.append(i);
                result.append(", ");
                result.append(v);
                result.append("): ");
                result.append(map.get(v));
                result.append("\r\n");
            }
        }
        for (i = 0; i < this.finals.length; ++i) {
            if (this.finals[i] == null) continue;
            result.append("final(");
            result.append(i);
            result.append("): ");
            result.append(this.finals[i]);
            result.append("\r\n");
        }
        return result.toString();
    }
}

