/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker;

import com.blamejared.crafttweaker.CraftTweakerRegistries;
import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.CraftTweakerRegistry;
import com.blamejared.crafttweaker.api.ScriptLoadingOptions;
import com.blamejared.crafttweaker.api.zencode.impl.FileAccessSingle;
import com.blamejared.crafttweaker.impl.commands.CTCommands;
import com.blamejared.crafttweaker.impl.commands.custom.CustomCommands;
import com.blamejared.crafttweaker.impl.events.CTClientEventHandler;
import com.blamejared.crafttweaker.impl.events.CTEventHandler;
import com.blamejared.crafttweaker.impl.ingredients.IngredientNBT;
import com.blamejared.crafttweaker.impl.logger.GroupLogger;
import com.blamejared.crafttweaker.impl.logger.PlayerLogger;
import com.blamejared.crafttweaker.impl.managers.CTCraftingTableManager;
import com.blamejared.crafttweaker.impl.network.PacketHandler;
import com.blamejared.crafttweaker.impl.recipes.SerializerShaped;
import com.blamejared.crafttweaker.impl.recipes.SerializerShapeless;
import com.blamejared.crafttweaker.impl.script.ScriptRecipe;
import com.blamejared.crafttweaker.impl.script.SerializerScript;
import com.mojang.brigadier.CommandDispatcher;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.command.CommandSource;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IReloadableResourceManager;
import net.minecraft.resources.IResourceManagerReloadListener;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RecipesUpdatedEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.server.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.openzen.zencode.shared.SourceFile;

@Mod(value="crafttweaker")
public class CraftTweaker {
    public static final String MODID = "crafttweaker";
    public static final String NAME = "CraftTweaker";
    public static final String VERSION = "5.0.0";
    public static final Logger LOG = LogManager.getLogger((String)"CraftTweaker");
    public static IRecipeSerializer SHAPELESS_SERIALIZER;
    public static IRecipeSerializer SHAPED_SERIALIZER;
    public static IRecipeSerializer SCRIPT_SERIALIZER;
    public static IIngredientSerializer<?> INGREDIENT_NBT_SERIALIZER;
    public static IRecipeType<ScriptRecipe> RECIPE_TYPE_SCRIPTS;
    private static Set<String> PATRON_LIST;

    public CraftTweaker() {
        CraftTweakerAPI.SCRIPT_DIR.mkdirs();
        CraftTweakerAPI.SCRIPT_DIR.mkdir();
        CraftTweakerAPI.setupLoggers();
        CraftTweakerRegistry.addAdvancedBEPName("recipemanager");
        CraftTweakerRegistry.findClasses();
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setupClient);
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)new CTEventHandler());
        PacketHandler.init();
        SHAPELESS_SERIALIZER = (IRecipeSerializer)new SerializerShapeless().setRegistryName(new ResourceLocation("crafttweaker:shapeless"));
        SHAPED_SERIALIZER = (IRecipeSerializer)new SerializerShaped().setRegistryName(new ResourceLocation("crafttweaker:shaped"));
        SCRIPT_SERIALIZER = (IRecipeSerializer)new SerializerScript().setRegistryName(new ResourceLocation("crafttweaker:scripts"));
        ForgeRegistries.RECIPE_SERIALIZERS.register((IForgeRegistryEntry)SHAPELESS_SERIALIZER);
        ForgeRegistries.RECIPE_SERIALIZERS.register((IForgeRegistryEntry)SHAPED_SERIALIZER);
        ForgeRegistries.RECIPE_SERIALIZERS.register((IForgeRegistryEntry)SCRIPT_SERIALIZER);
        RECIPE_TYPE_SCRIPTS = IRecipeType.func_222147_a((String)"crafttweaker:scripts");
        INGREDIENT_NBT_SERIALIZER = new IngredientNBT.Serializer();
        CraftingHelper.register((ResourceLocation)new ResourceLocation(MODID, "nbt"), INGREDIENT_NBT_SERIALIZER);
        CraftTweakerRegistries.init();
        new Thread(() -> {
            try {
                URL url = new URL("https://blamejared.com/patrons.txt");
                URLConnection urlConnection = url.openConnection();
                urlConnection.setConnectTimeout(15000);
                urlConnection.setReadTimeout(15000);
                urlConnection.setRequestProperty("User-Agent", "CraftTweaker|1.15.2");
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(urlConnection.getInputStream()));){
                    PATRON_LIST = reader.lines().filter(s -> !s.isEmpty()).collect(Collectors.toSet());
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }).start();
    }

    private void setup(FMLCommonSetupEvent event) {
        ScriptLoadingOptions setupCommon = new ScriptLoadingOptions().setLoaderName("setupCommon").firstRun().execute();
        CraftTweakerAPI.loadScripts(setupCommon);
        LOG.info("{} has loaded successfully!", (Object)NAME);
    }

    private void setupClient(FMLClientSetupEvent event) {
        LOG.info("{} client has loaded successfully!", (Object)NAME);
        MinecraftForge.EVENT_BUS.register((Object)new CTClientEventHandler());
    }

    @SubscribeEvent
    public void playerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        ((GroupLogger)CraftTweakerAPI.logger).addLogger(new PlayerLogger(event.getPlayer()));
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void getRecipes(RecipesUpdatedEvent event) {
        if (((Map)event.getRecipeManager().field_199522_d.getOrDefault(RECIPE_TYPE_SCRIPTS, new HashMap())).size() == 0) {
            return;
        }
        CTClientEventHandler.TOOLTIPS.clear();
        CTCraftingTableManager.recipeManager = event.getRecipeManager();
        Map map = event.getRecipeManager().field_199522_d.getOrDefault(RECIPE_TYPE_SCRIPTS, new HashMap());
        Collection recipes = map.values();
        CraftTweakerAPI.NO_BRAND = false;
        ScriptLoadingOptions scriptLoadingOptions = new ScriptLoadingOptions().execute();
        Comparator<FileAccessSingle> comparator = FileAccessSingle.createComparator(CraftTweakerRegistry.getPreprocessors());
        SourceFile[] sourceFiles = (SourceFile[])recipes.stream().map(iRecipe -> (ScriptRecipe)iRecipe).map(recipe -> new FileAccessSingle(recipe.getFileName(), new StringReader(recipe.getContent()), scriptLoadingOptions, CraftTweakerRegistry.getPreprocessors())).filter(FileAccessSingle::shouldBeLoaded).sorted(comparator).map(FileAccessSingle::getSourceFile).toArray(SourceFile[]::new);
        CraftTweakerAPI.loadScripts(sourceFiles, scriptLoadingOptions);
    }

    @SubscribeEvent
    public void serverStarting(FMLServerStartingEvent event) {
        CTCommands.init((CommandDispatcher<CommandSource>)event.getCommandDispatcher());
        CustomCommands.init((CommandDispatcher<CommandSource>)event.getCommandDispatcher());
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void startServer(FMLServerAboutToStartEvent event) {
        CraftTweakerAPI.startFirstRun();
        IReloadableResourceManager manager = event.getServer().func_195570_aG();
        manager.func_219534_a((IFutureReloadListener)((IResourceManagerReloadListener)resourceManager -> {
            String name;
            event.getServer().func_184103_al().func_148539_a((ITextComponent)new StringTextComponent("CraftTweaker reload starting!"));
            RecipeManager recipeManager = event.getServer().func_199529_aN();
            recipeManager.field_199522_d = new HashMap(recipeManager.field_199522_d);
            recipeManager.field_199522_d.replaceAll((t, v) -> new HashMap((Map)recipeManager.field_199522_d.get(t)));
            CTCraftingTableManager.recipeManager = recipeManager;
            CraftTweakerAPI.loadScripts(new ScriptLoadingOptions().execute());
            List<File> scriptFiles = CraftTweakerAPI.getScriptFiles();
            scriptFiles.stream().map(file -> new ScriptRecipe(new ResourceLocation(MODID, file.getPath().substring("scripts\\".length()).replaceAll("[^a-z0-9_.-]", "_")), file.getPath().substring("scripts\\".length()), this.readContents((File)file))).forEach(scriptRecipe -> {
                Map map = recipeManager.field_199522_d.computeIfAbsent(RECIPE_TYPE_SCRIPTS, iRecipeType -> new HashMap());
                map.put(scriptRecipe.func_199560_c(), scriptRecipe);
            });
            StringTextComponent msg = new StringTextComponent("CraftTweaker reload complete!");
            event.getServer().func_184103_al().func_148539_a((ITextComponent)msg);
            if (scriptFiles.size() > 0 && !CraftTweakerAPI.NO_BRAND && !(name = PATRON_LIST.stream().skip(PATRON_LIST.isEmpty() ? 0L : (long)new Random().nextInt(PATRON_LIST.size())).findFirst().orElse("")).isEmpty()) {
                msg = new StringTextComponent("This reload was made possible by " + name + " and more!" + TextFormatting.GREEN + " [Learn more!]");
                msg.func_150255_a(new Style().func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://patreon.com/jaredlll08?s=crtmod")).func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new StringTextComponent(TextFormatting.GREEN + "Click to learn more!"))));
                event.getServer().func_184103_al().func_148539_a((ITextComponent)msg);
            }
        }));
    }

    public String readContents(File file) {
        try {
            return new BufferedReader(new FileReader(file)).lines().collect(Collectors.joining("\r\n"));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return "";
        }
    }

    static {
        PATRON_LIST = new HashSet<String>();
    }
}

