/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.item;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker.api.data.IData;
import com.blamejared.crafttweaker.api.data.NBTConverter;
import com.blamejared.crafttweaker.api.item.IIngredient;
import com.blamejared.crafttweaker.api.item.tooltip.ITooltipFunction;
import com.blamejared.crafttweaker.impl.actions.items.ActionSetBurnTime;
import com.blamejared.crafttweaker.impl.actions.items.tooltips.ActionAddShiftedTooltip;
import com.blamejared.crafttweaker.impl.actions.items.tooltips.ActionAddTooltip;
import com.blamejared.crafttweaker.impl.actions.items.tooltips.ActionClearTooltip;
import com.blamejared.crafttweaker.impl.actions.items.tooltips.ActionModifyTooltip;
import com.blamejared.crafttweaker.impl.actions.items.tooltips.ActionRemoveRegexTooltip;
import com.blamejared.crafttweaker.impl.data.MapData;
import com.blamejared.crafttweaker.impl.food.MCFood;
import com.blamejared.crafttweaker.impl.util.text.MCTextComponent;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import com.blamejared.crafttweaker_annotations.annotations.ZenWrapper;
import java.util.regex.Pattern;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraftforge.common.ForgeHooks;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="crafttweaker.api.item.IItemStack")
@Document(value="vanilla/api/items/IItemStack")
@ZenWrapper(wrappedClass="net.minecraft.item.ItemStack", conversionMethodFormat="%s.getInternal()", displayStringFormat="%s.getCommandString()", creationMethodFormat="new MCItemStack(%s)", implementingClass="com.blamejared.crafttweaker.impl.item.MCItemStack")
public interface IItemStack
extends IIngredient {
    @ZenCodeType.Method
    public IItemStack copy();

    @ZenCodeType.Getter(value="registryName")
    default public String getRegistryName() {
        return this.getInternal().func_77973_b().getRegistryName().toString();
    }

    @ZenCodeType.Getter(value="owner")
    default public String getOwner() {
        return this.getInternal().func_77973_b().getRegistryName().func_110624_b();
    }

    @ZenCodeType.Getter(value="empty")
    default public boolean isEmpty() {
        return this.getInternal().func_190926_b();
    }

    @ZenCodeType.Getter(value="maxStackSize")
    default public int getMaxStackSize() {
        return this.getInternal().func_77973_b().getItemStackLimit(this.getInternal());
    }

    @ZenCodeType.Getter(value="displayName")
    default public String getDisplayName() {
        return this.getInternal().func_200301_q().func_150254_d();
    }

    @ZenCodeType.Method
    default public void clearCustomName() {
        this.getInternal().func_135074_t();
    }

    @ZenCodeType.Getter(value="hasDisplayName")
    default public boolean hasDisplayName() {
        return this.getInternal().func_82837_s();
    }

    @ZenCodeType.Getter(value="hasEffect")
    default public boolean hasEffect() {
        return this.getInternal().func_77962_s();
    }

    @ZenCodeType.Getter(value="isEnchantable")
    default public boolean isEnchantable() {
        return this.getInternal().func_77956_u();
    }

    @ZenCodeType.Getter(value="isEnchanted")
    default public boolean isEnchanted() {
        return this.getInternal().func_77948_v();
    }

    @ZenCodeType.Getter(value="getRepairCost")
    default public int getRepairCost() {
        return this.getInternal().func_82838_A();
    }

    @ZenCodeType.Method
    public IItemStack setDisplayName(String var1);

    @ZenCodeType.Getter(value="amount")
    default public int getAmount() {
        return this.getInternal().func_190916_E();
    }

    @ZenCodeType.Operator(value=ZenCodeType.OperatorType.MUL)
    public IItemStack setAmount(int var1);

    @ZenCodeType.Getter(value="stackable")
    default public boolean isStackable() {
        return this.getInternal().func_77985_e();
    }

    @ZenCodeType.Method
    public IItemStack withDamage(int var1);

    @ZenCodeType.Getter(value="damageable")
    default public boolean isDamageable() {
        return this.getInternal().func_77984_f();
    }

    @ZenCodeType.Getter(value="damaged")
    default public boolean isDamaged() {
        return this.getInternal().func_77951_h();
    }

    @ZenCodeType.Getter(value="maxDamage")
    default public int getMaxDamage() {
        return this.getInternal().func_77958_k();
    }

    @ZenCodeType.Getter(value="translationKey")
    default public String getTranslationKey() {
        return this.getInternal().func_77977_a();
    }

    @ZenCodeType.Method
    public IItemStack withTag(IData var1);

    @ZenCodeType.Getter(value="hasTag")
    default public boolean hasTag() {
        return this.getInternal().func_77942_o();
    }

    @ZenCodeType.Getter(value="tag")
    default public IData getTag() {
        return NBTConverter.convert((INBT)this.getInternal().func_77978_p());
    }

    @ZenCodeType.Getter(value="getOrCreate")
    default public IData getOrCreateTag() {
        if (this.getInternal().func_77978_p() == null) {
            this.getInternal().func_77982_d(new CompoundNBT());
        }
        return NBTConverter.convert((INBT)this.getInternal().func_77978_p());
    }

    @Override
    default public boolean matches(IItemStack stack, boolean ignoreDamage) {
        ItemStack stack1 = this.getInternal();
        ItemStack stack2 = stack.getInternal();
        if (stack1.func_190926_b() != stack2.func_190926_b()) {
            return false;
        }
        if (stack1.func_77973_b() != stack2.func_77973_b()) {
            return false;
        }
        if (stack1.func_190916_E() > stack2.func_190916_E()) {
            return false;
        }
        if (!ignoreDamage && stack1.func_77952_i() != stack2.func_77952_i()) {
            return false;
        }
        CompoundNBT stack1Tag = stack1.func_77978_p();
        CompoundNBT stack2Tag = stack2.func_77978_p();
        if (stack1Tag == null && stack2Tag == null) {
            return true;
        }
        MapData stack2Data = (MapData)NBTConverter.convert((INBT)stack2Tag);
        MapData stack1Data = (MapData)NBTConverter.convert((INBT)stack1Tag);
        if (stack1Data == null) {
            return true;
        }
        if (ignoreDamage) {
            stack1Data = (MapData)stack1Data.copyInternal();
            stack1Data.remove("Damage");
            if (stack2Data != null) {
                stack2Data = (MapData)stack2Data.copyInternal();
                stack2Data.remove("Damage");
            }
        }
        return stack2Data != null && stack2Data.contains(stack1Data);
    }

    @ZenCodeType.Getter(value="useDuration")
    default public int getUseDuration() {
        return this.getInternal().func_77988_m();
    }

    @ZenCodeType.Getter(value="isCrossbow")
    default public boolean isCrossbowStack() {
        return this.getInternal().func_222122_m();
    }

    @ZenCodeType.Getter(value="food")
    public MCFood getFood();

    @ZenCodeType.Setter(value="food")
    public void setFood(MCFood var1);

    @ZenCodeType.Getter(value="burnTime")
    default public int getBurnTime() {
        return ForgeHooks.getBurnTime((ItemStack)this.getInternal());
    }

    @ZenCodeType.Setter(value="burnTime")
    default public void setBurnTime(int time) {
        CraftTweakerAPI.apply(new ActionSetBurnTime(this, time));
    }

    @ZenCodeType.Method
    default public void clearTooltip() {
        CraftTweakerAPI.apply(new ActionClearTooltip(this));
    }

    @ZenCodeType.Method
    default public void addTooltip(MCTextComponent content) {
        CraftTweakerAPI.apply(new ActionAddTooltip(this, content));
    }

    @ZenCodeType.Method
    default public void addShiftTooltip(MCTextComponent content, @ZenCodeType.Optional MCTextComponent showMessage) {
        CraftTweakerAPI.apply(new ActionAddShiftedTooltip(this, content, showMessage));
    }

    @ZenCodeType.Method
    default public void modifyTooltip(ITooltipFunction function) {
        CraftTweakerAPI.apply(new ActionModifyTooltip(this, function));
    }

    @ZenCodeType.Method
    default public void removeTooltip(String regex) {
        CraftTweakerAPI.apply(new ActionRemoveRegexTooltip(this, Pattern.compile(regex)));
    }

    @ZenCodeType.Method
    public IItemStack mutable();

    @ZenCodeType.Getter(value="damage")
    public int getDamage();

    public ItemStack getInternal();
}

