/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.actions.recipes;

import com.blamejared.crafttweaker.api.logger.ILogger;
import com.blamejared.crafttweaker.api.managers.IRecipeManager;
import com.blamejared.crafttweaker.impl.actions.recipes.ActionRecipeBase;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;

public class ActionRemoveRecipeByName
extends ActionRecipeBase {
    private final ResourceLocation name;

    public ActionRemoveRecipeByName(IRecipeManager manager, ResourceLocation name) {
        super(manager);
        this.name = name;
    }

    @Override
    public void apply() {
        this.getManager().getRecipes().remove(this.name);
    }

    @Override
    public String describe() {
        return "Removing \"" + Registry.field_218367_H.func_177774_c((Object)this.getManager().getRecipeType()) + "\" recipe with name: \"" + this.name + "\"";
    }

    @Override
    public boolean validate(ILogger logger) {
        boolean containsKey = this.getManager().getRecipes().containsKey(this.name);
        if (!containsKey) {
            logger.warning("No recipe with type: \"" + Registry.field_218367_H.func_177774_c((Object)this.getManager().getRecipeType()) + "\" and name: \"" + this.name + "\"");
        }
        return containsKey;
    }
}

