/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.item;

import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker.api.item.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import net.minecraft.item.crafting.Ingredient;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="crafttweaker.api.item.IngredientList")
@Document(value="vanilla/api/items/IngredientList")
public class MCIngredientList
implements IIngredient {
    private IIngredient[] ingredients;

    public MCIngredientList(IIngredient[] ingredients) {
        this.ingredients = ingredients;
    }

    @Override
    public boolean matches(IItemStack stack, boolean ignoreDamage) {
        for (IIngredient item : this.ingredients) {
            if (!item.matches(stack, ignoreDamage)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Ingredient asVanillaIngredient() {
        return Ingredient.merge((Collection)Arrays.stream(this.ingredients).map(IIngredient::asVanillaIngredient).collect(Collectors.toList()));
    }

    @Override
    public String getCommandString() {
        return Arrays.stream(this.ingredients).map(IIngredient::getCommandString).collect(Collectors.joining(" | "));
    }

    @Override
    public IItemStack[] getItems() {
        ArrayList stacks = new ArrayList();
        Arrays.stream(this.ingredients).map(ing -> Arrays.asList(ing.getItems())).forEach(stacks::addAll);
        return stacks.toArray(new IItemStack[0]);
    }
}

