/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.item;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.data.IData;
import com.blamejared.crafttweaker.api.data.NBTConverter;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.impl.actions.items.ActionSetFood;
import com.blamejared.crafttweaker.impl.data.MapData;
import com.blamejared.crafttweaker.impl.food.MCFood;
import com.blamejared.crafttweaker.impl.ingredients.IngredientNBT;
import com.blamejared.crafttweaker.impl.item.MCItemStackMutable;
import java.util.function.Supplier;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.INBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class MCItemStack
implements IItemStack {
    private final ItemStack internal;
    public static Supplier<MCItemStack> EMPTY = () -> new MCItemStack(ItemStack.field_190927_a);

    public MCItemStack(ItemStack internal) {
        this.internal = internal.func_77946_l();
    }

    @Override
    public IItemStack copy() {
        return new MCItemStack(this.getInternal().func_77946_l());
    }

    @Override
    public IItemStack setDisplayName(String name) {
        ItemStack newStack = this.getInternal().func_77946_l();
        newStack.func_200302_a((ITextComponent)new StringTextComponent(name));
        return new MCItemStack(newStack);
    }

    @Override
    public IItemStack setAmount(int amount) {
        ItemStack newStack = this.getInternal().func_77946_l();
        newStack.func_190920_e(amount);
        return new MCItemStack(newStack);
    }

    @Override
    public IItemStack withDamage(int damage) {
        ItemStack copy = this.getInternal().func_77946_l();
        copy.func_196085_b(damage);
        return new MCItemStack(copy);
    }

    @Override
    public IItemStack withTag(IData tag) {
        ItemStack copy = this.getInternal().func_77946_l();
        if (!(tag instanceof MapData)) {
            tag = new MapData(tag.asMap());
        }
        copy.func_77982_d(((MapData)tag).getInternal());
        return new MCItemStack(copy);
    }

    @Override
    public MCFood getFood() {
        return new MCFood(this.getInternal().func_77973_b().func_219967_s());
    }

    @Override
    public void setFood(MCFood food) {
        CraftTweakerAPI.apply(new ActionSetFood(this, food));
    }

    @Override
    public String getCommandString() {
        StringBuilder sb = new StringBuilder("<item:");
        sb.append(this.getInternal().func_77973_b().getRegistryName());
        sb.append(">");
        if (this.getInternal().func_77978_p() != null) {
            MapData data = (MapData)NBTConverter.convert((INBT)this.getInternal().func_77978_p()).copyInternal();
            if (this.getInternal().func_77951_h()) {
                data.remove("Damage");
            }
            if (!data.isEmpty()) {
                sb.append(".withTag(");
                sb.append(data.asString());
                sb.append(")");
            }
        }
        if (this.getInternal().func_77952_i() > 0) {
            sb.append(".withDamage(").append(this.getInternal().func_77952_i()).append(")");
        }
        if (this.getAmount() != 1) {
            sb.append(" * ").append(this.getAmount());
        }
        return sb.toString();
    }

    @Override
    public ItemStack getInternal() {
        return this.internal;
    }

    @Override
    public int getDamage() {
        return this.internal.func_77952_i();
    }

    @Override
    public IItemStack mutable() {
        return new MCItemStackMutable(this.internal);
    }

    @Override
    public Ingredient asVanillaIngredient() {
        if (this.getInternal().func_190926_b()) {
            return Ingredient.field_193370_a;
        }
        if (!this.getInternal().func_77942_o()) {
            return Ingredient.func_193369_a((ItemStack[])new ItemStack[]{this.getInternal()});
        }
        return new IngredientNBT(this.getInternal());
    }

    public String toString() {
        return this.getCommandString();
    }

    @Override
    public IItemStack[] getItems() {
        return new IItemStack[]{this};
    }
}

