/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zenscript.codemodel;

public class Modifiers {
    public static final int PUBLIC = 1;
    public static final int INTERNAL = 2;
    public static final int PRIVATE = 4;
    public static final int ABSTRACT = 8;
    public static final int FINAL = 16;
    public static final int CONST = 32;
    public static final int CONST_OPTIONAL = 64;
    public static final int STATIC = 128;
    public static final int PROTECTED = 256;
    public static final int IMPLICIT = 512;
    public static final int VIRTUAL = 1024;
    public static final int EXTERN = 2048;
    public static final int OVERRIDE = 4096;

    private Modifiers() {
    }

    public static boolean isPublic(int modifiers) {
        return (modifiers & 1) > 0;
    }

    public static boolean isInternal(int modifiers) {
        return (modifiers & 2) > 0;
    }

    public static boolean isProtected(int modifiers) {
        return (modifiers & 0x100) > 0;
    }

    public static boolean isPrivate(int modifiers) {
        return (modifiers & 4) > 0;
    }

    public static boolean isAbstract(int modifiers) {
        return (modifiers & 8) > 0;
    }

    public static boolean isFinal(int modifiers) {
        return (modifiers & 0x10) > 0;
    }

    public static boolean isConst(int modifiers) {
        return (modifiers & 0x20) > 0;
    }

    public static boolean isConstOptional(int modifiers) {
        return (modifiers & 0x40) > 0;
    }

    public static boolean isStatic(int modifiers) {
        return (modifiers & 0x80) > 0;
    }

    public static boolean isImplicit(int modifiers) {
        return (modifiers & 0x200) > 0;
    }

    public static boolean isVirtual(int modifiers) {
        return (modifiers & 0x400) > 0;
    }

    public static boolean isExtern(int modifiers) {
        return (modifiers & 0x800) > 0;
    }

    public static boolean isOverride(int modifiers) {
        return (modifiers & 0x1000) > 0;
    }

    public static boolean hasAccess(int modifiers) {
        return (modifiers & 0x107) > 0;
    }

    public static String describe(int modifiers) {
        StringBuilder builder = new StringBuilder();
        if (Modifiers.isPublic(modifiers)) {
            builder.append("public");
        } else if (Modifiers.isPrivate(modifiers)) {
            builder.append("private");
        } else if (Modifiers.isProtected(modifiers)) {
            builder.append("protected");
        }
        if (Modifiers.isAbstract(modifiers)) {
            builder.append(" abstract");
        } else if (Modifiers.isFinal(modifiers)) {
            builder.append(" final");
        } else if (Modifiers.isStatic(modifiers)) {
            builder.append(" static");
        }
        return builder.toString();
    }
}

