/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zenscript.parser.expression;

import org.openzen.zencode.shared.CodePosition;
import org.openzen.zencode.shared.CompileException;
import org.openzen.zenscript.codemodel.expression.Expression;
import org.openzen.zenscript.codemodel.expression.OrOrExpression;
import org.openzen.zenscript.codemodel.partial.IPartialExpression;
import org.openzen.zenscript.codemodel.scope.ExpressionScope;
import org.openzen.zenscript.codemodel.type.BasicTypeID;
import org.openzen.zenscript.parser.expression.ParsedExpression;

public class ParsedExpressionOrOr
extends ParsedExpression {
    private final ParsedExpression left;
    private final ParsedExpression right;

    public ParsedExpressionOrOr(CodePosition position, ParsedExpression left, ParsedExpression right) {
        super(position);
        this.left = left;
        this.right = right;
    }

    @Override
    public IPartialExpression compile(ExpressionScope scope) throws CompileException {
        Expression cLeft = this.left.compile(scope.withHints(BasicTypeID.HINT_BOOL)).eval().castImplicit(this.position, scope, BasicTypeID.BOOL.stored);
        Expression cRight = this.right.compile(scope.withHints(BasicTypeID.HINT_BOOL)).eval().castImplicit(this.position, scope, BasicTypeID.BOOL.stored);
        return new OrOrExpression(this.position, cLeft, cRight);
    }

    @Override
    public boolean hasStrongType() {
        return this.left.hasStrongType() && this.right.hasStrongType();
    }
}

