/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api;

import com.blamejared.crafttweaker.CraftTweaker;
import com.blamejared.crafttweaker.api.CraftTweakerRegistry;
import com.blamejared.crafttweaker.api.ScriptLoadingOptions;
import com.blamejared.crafttweaker.api.actions.IAction;
import com.blamejared.crafttweaker.api.actions.IRuntimeAction;
import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker.api.logger.ILogger;
import com.blamejared.crafttweaker.api.logger.LogLevel;
import com.blamejared.crafttweaker.api.mods.MCMods;
import com.blamejared.crafttweaker.api.zencode.IPreprocessor;
import com.blamejared.crafttweaker.api.zencode.expands.IDataRewrites;
import com.blamejared.crafttweaker.api.zencode.impl.FileAccessSingle;
import com.blamejared.crafttweaker.api.zencode.impl.loaders.LoaderActions;
import com.blamejared.crafttweaker.api.zencode.impl.loaders.ScriptRun;
import com.blamejared.crafttweaker.impl.game.MCGame;
import com.blamejared.crafttweaker.impl.logger.FileLogger;
import com.blamejared.crafttweaker.impl.logger.GroupLogger;
import com.blamejared.crafttweaker.impl.script.ScriptRecipe;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraftforge.fml.common.thread.EffectiveSide;
import org.openzen.zencode.java.ScriptingEngine;
import org.openzen.zencode.java.ZenCodeGlobals;
import org.openzen.zencode.shared.SourceFile;
import org.openzen.zenscript.parser.expression.ParsedExpressionArray;
import org.openzen.zenscript.parser.expression.ParsedExpressionMap;

@ZenRegister
public class CraftTweakerAPI {
    public static final File SCRIPT_DIR = new File("scripts");
    @ZenCodeGlobals.Global
    public static ILogger logger;
    @ZenCodeGlobals.Global
    public static MCMods loadedMods;
    @ZenCodeGlobals.Global
    public static MCGame game;
    public static boolean DEBUG_MODE;
    public static boolean NO_BRAND;
    private static ScriptRun currentRun;

    public static void apply(IAction action) {
        ScriptRun currentRun = CraftTweakerAPI.getCurrentRun();
        if (!(action instanceof IRuntimeAction) && !currentRun.isFirstRun()) {
            return;
        }
        LoaderActions currentLoaderActions = currentRun.getLoaderActions();
        try {
            if (!action.shouldApplyOn(EffectiveSide.get())) {
                return;
            }
            if (!action.validate(logger)) {
                currentLoaderActions.addInvalidAction(action);
                return;
            }
            String describe = action.describe();
            if (describe != null && !describe.isEmpty()) {
                CraftTweakerAPI.logInfo(describe, new Object[0]);
            }
            action.apply();
            currentLoaderActions.addValidAction(action);
        }
        catch (Exception e) {
            CraftTweakerAPI.logThrowing("Error running action", e, new Object[0]);
        }
    }

    public static List<File> getScriptFiles() {
        ArrayList<File> fileList = new ArrayList<File>();
        CraftTweakerAPI.findScriptFiles(SCRIPT_DIR, fileList);
        return fileList;
    }

    public static void loadScripts(ScriptLoadingOptions scriptLoadingOptions) {
        NO_BRAND = false;
        List<File> fileList = CraftTweakerAPI.getScriptFiles();
        Comparator<FileAccessSingle> comparator = FileAccessSingle.createComparator(CraftTweakerRegistry.getPreprocessors());
        SourceFile[] sourceFiles = (SourceFile[])fileList.stream().map(file -> new FileAccessSingle(SCRIPT_DIR, (File)file, scriptLoadingOptions, (Collection<IPreprocessor>)CraftTweakerRegistry.getPreprocessors())).filter(FileAccessSingle::shouldBeLoaded).sorted(comparator).map(FileAccessSingle::getSourceFile).toArray(SourceFile[]::new);
        CraftTweakerAPI.loadScripts(sourceFiles, scriptLoadingOptions);
    }

    public static void loadScripts(SourceFile[] sourceFiles, ScriptLoadingOptions scriptLoadingOptions) {
        currentRun = new ScriptRun(scriptLoadingOptions, sourceFiles);
        CraftTweakerAPI.logInfo("Started loading Scripts for Loader '%s'!", scriptLoadingOptions.getLoaderName());
        try {
            currentRun.reload();
            currentRun.run();
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.throwingErr("Error running scripts", e);
        }
        CraftTweakerAPI.logInfo("Finished loading Scripts!", new Object[0]);
    }

    public static void loadScriptsFromRecipeManager(RecipeManager recipeManager, ScriptLoadingOptions scriptLoadingOptions) {
        Map map = recipeManager.field_199522_d.getOrDefault(CraftTweaker.RECIPE_TYPE_SCRIPTS, new HashMap());
        Collection recipes = map.values();
        NO_BRAND = false;
        Comparator<FileAccessSingle> comparator = FileAccessSingle.createComparator(CraftTweakerRegistry.getPreprocessors());
        SourceFile[] sourceFiles = (SourceFile[])recipes.stream().map(iRecipe -> (ScriptRecipe)iRecipe).map(recipe -> new FileAccessSingle(recipe.getFileName(), new StringReader(recipe.getContent()), scriptLoadingOptions, CraftTweakerRegistry.getPreprocessors())).filter(FileAccessSingle::shouldBeLoaded).sorted(comparator).map(FileAccessSingle::getSourceFile).toArray(SourceFile[]::new);
        CraftTweakerAPI.loadScripts(sourceFiles, scriptLoadingOptions);
    }

    public static void findScriptFiles(File path, List<File> files) {
        if (path.isDirectory()) {
            for (File file : path.listFiles()) {
                if (file.isDirectory()) {
                    CraftTweakerAPI.findScriptFiles(file, files);
                    continue;
                }
                if (!file.getName().toLowerCase().endsWith(".zs")) continue;
                files.add(file);
            }
        }
    }

    public static void setupLoggers() {
        logger = new GroupLogger();
        ((GroupLogger)logger).addLogger(new FileLogger(new File("logs/crafttweaker.log")));
    }

    public static void logDump(String message, Object ... formats) {
        logger.log(LogLevel.INFO, String.format(message, formats), false);
    }

    public static void logInfo(String message, Object ... formats) {
        logger.info(String.format(message, formats));
    }

    public static void logDebug(String message, Object ... formats) {
        logger.debug(String.format(message, formats));
    }

    public static void logWarning(String message, Object ... formats) {
        logger.warning(String.format(message, formats));
    }

    public static void logError(String message, Object ... formats) {
        logger.error(String.format(message, formats));
    }

    public static void logThrowing(String message, Throwable e, Object ... formats) {
        logger.throwingErr(String.format(message, formats), e);
    }

    public static void log(LogLevel level, String filename, int lineNumber, String message, Object ... formats) {
        logger.log(level, String.format("[%s:%d%s]", filename, lineNumber, String.format(message, formats)));
    }

    public static List<IAction> getActionList() {
        LoaderActions loaderActions = CraftTweakerAPI.getCurrentRun().getLoaderActions();
        return ImmutableList.copyOf(loaderActions.getActionList());
    }

    public static List<IAction> getActionListInvalid() {
        LoaderActions loaderActions = CraftTweakerAPI.getCurrentRun().getLoaderActions();
        return ImmutableList.copyOf(loaderActions.getActionListInvalid());
    }

    public static ScriptRun getCurrentRun() {
        if (currentRun == null) {
            throw new IllegalStateException("Invalid current run!");
        }
        return currentRun;
    }

    public static boolean isServer() {
        return CraftTweaker.serverOverride || EffectiveSide.get().isServer();
    }

    public static ScriptingEngine getEngine() {
        return CraftTweakerAPI.getCurrentRun().getEngine();
    }

    public static String getDefaultLoaderName() {
        return "crafttweaker";
    }

    static {
        loadedMods = new MCMods();
        game = new MCGame();
        DEBUG_MODE = false;
        NO_BRAND = false;
        ParsedExpressionMap.compileOverrides.add(IDataRewrites::rewriteMap);
        ParsedExpressionArray.compileOverrides.add(IDataRewrites::rewriteArray);
    }
}

