/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.item;

import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker.api.brackets.CommandStringDisplayable;
import com.blamejared.crafttweaker.api.data.IData;
import com.blamejared.crafttweaker.api.data.JSONConverter;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.item.IngredientVanillaPlus;
import com.blamejared.crafttweaker.impl.data.MapData;
import com.blamejared.crafttweaker.impl.ingredients.conditions.ConditionAnyDamage;
import com.blamejared.crafttweaker.impl.ingredients.conditions.ConditionCustom;
import com.blamejared.crafttweaker.impl.ingredients.conditions.ConditionDamaged;
import com.blamejared.crafttweaker.impl.item.MCIngredientList;
import com.blamejared.crafttweaker.impl.item.MCItemStack;
import com.blamejared.crafttweaker.impl.item.conditions.MCIngredientConditioned;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import com.blamejared.crafttweaker_annotations.annotations.ZenWrapper;
import java.util.Arrays;
import java.util.function.Predicate;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraftforge.common.ForgeHooks;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="crafttweaker.api.item.IIngredient")
@Document(value="vanilla/api/items/IIngredient")
@ZenWrapper(wrappedClass="net.minecraft.item.crafting.Ingredient", conversionMethodFormat="%s.asVanillaIngredient()", displayStringFormat="%.getCommandString()")
public interface IIngredient
extends CommandStringDisplayable {
    @ZenCodeType.Method
    default public boolean matches(IItemStack stack) {
        return this.matches(stack, false);
    }

    @ZenCodeType.Method
    public boolean matches(IItemStack var1, boolean var2);

    @ZenCodeType.Method
    @ZenCodeType.Caster(implicit=true)
    public Ingredient asVanillaIngredient();

    @ZenCodeType.Method
    default public IItemStack getRemainingItem(IItemStack stack) {
        return new MCItemStack(ForgeHooks.getContainerItem((ItemStack)stack.getInternal()));
    }

    @Override
    @ZenCodeType.Getter(value="commandString")
    public String getCommandString();

    @ZenCodeType.Getter(value="items")
    public IItemStack[] getItems();

    @ZenCodeType.Method
    default public MCIngredientConditioned<IIngredient> onlyDamaged() {
        return new MCIngredientConditioned<IIngredient>(this, new ConditionDamaged());
    }

    @ZenCodeType.Method
    default public MCIngredientConditioned<IIngredient> anyDamage() {
        return new MCIngredientConditioned<IIngredient>(this, new ConditionAnyDamage());
    }

    @ZenCodeType.Method
    default public MCIngredientConditioned<IIngredient> onlyIf(String uid, @ZenCodeType.Optional Predicate<IItemStack> function) {
        return new MCIngredientConditioned<IIngredient>(this, new ConditionCustom(uid, function));
    }

    public static IIngredient fromIngredient(Ingredient ingredient) {
        if (ingredient instanceof IngredientVanillaPlus) {
            return ((IngredientVanillaPlus)ingredient).getCrTIngredient();
        }
        if (ingredient.func_203189_d()) {
            return new MCItemStack(ItemStack.field_190927_a);
        }
        if (ingredient.func_193365_a().length == 1) {
            return new MCItemStack(ingredient.func_193365_a()[0]);
        }
        return new MCIngredientList((IIngredient[])Arrays.stream(ingredient.func_193365_a()).map(MCItemStack::new).toArray(IItemStack[]::new));
    }

    @ZenCodeType.Caster(implicit=true)
    default public MapData asMapData() {
        IData data = this.asIData();
        return data instanceof MapData ? (MapData)data : new MapData();
    }

    @ZenCodeType.Caster(implicit=true)
    default public IData asIData() {
        return JSONConverter.convert(this.asVanillaIngredient().func_200304_c());
    }

    @ZenCodeType.Operator(value=ZenCodeType.OperatorType.OR)
    default public MCIngredientList or(IIngredient other) {
        return new MCIngredientList(new IIngredient[]{this, other});
    }
}

