/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.zencode.impl.native_types;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.zencode.impl.registry.ZenClassRegistry;
import com.blamejared.crafttweaker.impl.native_types.CrTNativeTypeInfo;
import com.blamejared.crafttweaker.impl.native_types.NativeTypeRegistry;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import org.openzen.zencode.java.ZenCodeType;
import org.openzen.zencode.java.module.JavaNativeTypeConversionContext;
import org.openzen.zencode.java.module.converters.JavaNativeClassConverter;
import org.openzen.zencode.java.module.converters.JavaNativeHeaderConverter;
import org.openzen.zencode.java.module.converters.JavaNativeMemberConverter;
import org.openzen.zencode.java.module.converters.JavaNativePackageInfo;
import org.openzen.zencode.java.module.converters.JavaNativeTypeConverter;

class CrTJavaNativeClassConverter
extends JavaNativeClassConverter {
    private final ZenClassRegistry zenClassRegistry;

    public CrTJavaNativeClassConverter(JavaNativePackageInfo packageInfo, JavaNativeTypeConversionContext typeConversionContext, JavaNativeTypeConverter typeConverter, JavaNativeHeaderConverter headerConverter, JavaNativeMemberConverter memberConverter, ZenClassRegistry zenClassRegistry) {
        super(typeConverter, memberConverter, packageInfo, typeConversionContext, headerConverter);
        this.zenClassRegistry = zenClassRegistry;
    }

    @Override
    public String getNameForScripts(Class<?> cls) {
        if (this.getNativeTypeRegistry().hasInfoFor(cls)) {
            return this.getNativeTypeRegistry().getCrTNameFor(cls);
        }
        if (cls.getCanonicalName().startsWith("net.minecraft")) {
            CraftTweakerAPI.logger.trace("Minecraft Type referenced but not registered: " + cls.getCanonicalName());
        }
        return super.getNameForScripts(cls);
    }

    private NativeTypeRegistry getNativeTypeRegistry() {
        return this.zenClassRegistry.getNativeTypeRegistry();
    }

    @Override
    public boolean shouldLoadClass(Class<?> cls) {
        if (this.zenClassRegistry.isBlacklisted(cls)) {
            CraftTweakerAPI.logInfo("Not loading class because of blacklist: " + cls.getCanonicalName(), new Object[0]);
            return false;
        }
        return super.shouldLoadClass(cls);
    }

    @Override
    protected ZenCodeType.Constructor getConstructorAnnotation(Constructor<?> constructor) {
        ZenCodeType.Constructor result;
        Class<?> declaringClass = constructor.getDeclaringClass();
        if (this.getNativeTypeRegistry().hasInfoFor(declaringClass) && (result = this.getNativeConstructorAnnotation(constructor)) != null) {
            return result;
        }
        return super.getConstructorAnnotation(constructor);
    }

    private ZenCodeType.Constructor getNativeConstructorAnnotation(Constructor<?> constructor) {
        if (this.isConstructorRegisteredFor(constructor)) {
            return this.createConstructorAnnotation();
        }
        return null;
    }

    private boolean isConstructorRegisteredFor(Constructor<?> constructor) {
        Class[] parameterTypes = constructor.getParameterTypes();
        CrTNativeTypeInfo typeInfoFor = this.getNativeTypeRegistry().getTypeInfoFor(constructor.getDeclaringClass());
        return typeInfoFor.getConstructors().stream().anyMatch(arguments -> Arrays.equals(arguments, parameterTypes));
    }

    private ZenCodeType.Constructor createConstructorAnnotation() {
        return new ZenCodeType.Constructor(){

            @Override
            public Class<? extends Annotation> annotationType() {
                return ZenCodeType.Constructor.class;
            }
        };
    }
}

