/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.commands.script_examples;

import com.blamejared.crafttweaker.impl.commands.script_examples.ClassPathSourceFile;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.SortedSet;
import java.util.TreeSet;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.eventbus.api.Event;
import org.openzen.zencode.shared.SourceFile;

public class ExampleCollectionEvent
extends Event {
    private final SortedSet<SourceFile> sourceFiles = new TreeSet<SourceFile>(Comparator.comparing(SourceFile::getFilename));
    private final IResourceManager resourceManager;

    public ExampleCollectionEvent(IResourceManager resourceManager) {
        this.resourceManager = resourceManager;
    }

    public Collection<SourceFile> getSourceFiles() {
        return Collections.unmodifiableSet(this.sourceFiles);
    }

    public void add(SourceFile sourceFile) {
        this.sourceFiles.add(sourceFile);
    }

    public void addResource(ResourceLocation location) {
        ClassPathSourceFile sourceFile = ClassPathSourceFile.fromLocation(location, this.resourceManager);
        if (sourceFile != null) {
            this.add(sourceFile);
        }
    }
}

