/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.events;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.actions.IUndoableAction;
import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import java.util.function.Consumer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@Document(value="vanilla/api/event/CTEventManager")
@ZenCodeType.Name(value="crafttweaker.api.events.CTEventManager")
public class CTEventManager {
    @ZenCodeType.Method
    public static <T extends Event> void register(final Class<T> typeOfT, final Consumer<T> consumer) {
        CraftTweakerAPI.apply(new IUndoableAction(){

            @Override
            public void undo() {
                MinecraftForge.EVENT_BUS.unregister((Object)consumer);
            }

            @Override
            public String describeUndo() {
                return "Unregistering event listener for " + typeOfT.getSimpleName() + ".";
            }

            @Override
            public void apply() {
                MinecraftForge.EVENT_BUS.addListener(EventPriority.NORMAL, false, typeOfT, consumer);
            }

            @Override
            public String describe() {
                return "Registering event listener for " + typeOfT.getSimpleName() + ".";
            }
        });
    }
}

