/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.fluid;

import com.blamejared.crafttweaker.api.fluid.IFluidStack;
import java.util.Objects;
import net.minecraft.fluid.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.openzen.zencode.java.ZenCodeType;

public class MCFluidStackMutable
implements IFluidStack {
    private final FluidStack stack;

    public MCFluidStackMutable(FluidStack stack) {
        this.stack = stack;
    }

    @Override
    public IFluidStack setAmount(int amount) {
        return this.multiply(amount);
    }

    @Override
    public IFluidStack multiply(int amount) {
        this.stack.setAmount(amount);
        return this;
    }

    @Override
    public IFluidStack mutable() {
        return this;
    }

    @Override
    public Fluid getFluid() {
        return this.stack.getFluid();
    }

    @Override
    public IFluidStack copy() {
        return new MCFluidStackMutable(this.stack.copy());
    }

    @Override
    public FluidStack getInternal() {
        return this.stack;
    }

    @Override
    public String getCommandString() {
        Fluid fluid = this.stack.getFluid();
        StringBuilder stringBuilder = new StringBuilder("<fluid:");
        stringBuilder.append(fluid.getRegistryName());
        stringBuilder.append(">.mutable()");
        if (this.stack.getAmount() != 1) {
            stringBuilder.append(" * ");
            stringBuilder.append(this.stack.getAmount());
        }
        return stringBuilder.toString();
    }

    @ZenCodeType.Operator(value=ZenCodeType.OperatorType.EQUALS)
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FluidStack thatStack = ((MCFluidStackMutable)o).stack;
        FluidStack thisStack = this.stack;
        if (thisStack.isEmpty()) {
            return thatStack.isEmpty();
        }
        if (thisStack.getAmount() != thatStack.getAmount()) {
            return false;
        }
        if (!Objects.equals(thisStack.getFluid(), thatStack.getFluid())) {
            return false;
        }
        return Objects.equals(thisStack.getTag(), thatStack.getTag());
    }

    public int hashCode() {
        return Objects.hash(this.stack.getAmount(), this.stack.getFluid(), this.stack.getTag());
    }
}

