/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.item;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.data.IData;
import com.blamejared.crafttweaker.api.data.NBTConverter;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.impl.actions.items.ActionSetFood;
import com.blamejared.crafttweaker.impl.data.MapData;
import com.blamejared.crafttweaker.impl.food.MCFood;
import com.blamejared.crafttweaker.impl.ingredients.IngredientNBT;
import java.util.Objects;
import net.minecraft.item.Food;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.INBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.common.capabilities.CapabilityProvider;
import org.openzen.zencode.java.ZenCodeType;

public class MCItemStackMutable
implements IItemStack {
    private final ItemStack internal;

    public MCItemStackMutable(ItemStack internal) {
        this.internal = internal;
    }

    @Override
    public IItemStack copy() {
        return new MCItemStackMutable(this.internal.func_77946_l());
    }

    @Override
    public IItemStack setDisplayName(String name) {
        this.getInternal().func_200302_a((ITextComponent)new StringTextComponent(name));
        return this;
    }

    @Override
    public IItemStack setAmount(int amount) {
        this.getInternal().func_190920_e(amount);
        return this;
    }

    @Override
    public IItemStack withDamage(int damage) {
        this.getInternal().func_196085_b(damage);
        return this;
    }

    @Override
    public MCFood getFood() {
        Food food = this.getInternal().func_77973_b().func_219967_s();
        return food == null ? null : new MCFood(food);
    }

    @Override
    public void setFood(MCFood food) {
        CraftTweakerAPI.apply(new ActionSetFood(this, food));
    }

    @Override
    public IItemStack withTag(IData tag) {
        if (!(tag instanceof MapData)) {
            tag = new MapData(tag.asMap());
        }
        this.getInternal().func_77982_d(((MapData)tag).getInternal());
        return this;
    }

    @Override
    public String getCommandString() {
        StringBuilder sb = new StringBuilder("<item:");
        sb.append(this.internal.func_77973_b().getRegistryName());
        sb.append(">");
        if (this.getInternal().func_77978_p() != null) {
            MapData data = (MapData)NBTConverter.convert((INBT)this.getInternal().func_77978_p()).copyInternal();
            if (this.getInternal().func_77973_b().func_77645_m()) {
                data.remove("Damage");
            }
            if (!data.isEmpty()) {
                sb.append(".withTag(");
                sb.append(data.asString());
                sb.append(")");
            }
        }
        if (this.internal.func_77952_i() > 0) {
            sb.append(".withDamage(").append(this.internal.func_77952_i()).append(")");
        }
        if (this.getAmount() != 1) {
            sb.append(" * ").append(this.getAmount());
        }
        return sb.toString();
    }

    @Override
    public ItemStack getInternal() {
        return this.internal;
    }

    @Override
    public int getDamage() {
        return this.internal.func_77952_i();
    }

    @Override
    public IItemStack mutable() {
        return this;
    }

    @Override
    public Ingredient asVanillaIngredient() {
        if (this.getInternal().func_190926_b()) {
            return Ingredient.field_193370_a;
        }
        if (!this.getInternal().func_77942_o()) {
            return Ingredient.func_193369_a((ItemStack[])new ItemStack[]{this.getInternal()});
        }
        return new IngredientNBT(this.getInternal());
    }

    public String toString() {
        return this.getCommandString();
    }

    @Override
    public IItemStack[] getItems() {
        return new IItemStack[]{this};
    }

    @ZenCodeType.Operator(value=ZenCodeType.OperatorType.EQUALS)
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ItemStack thatStack = ((MCItemStackMutable)o).internal;
        ItemStack thisStack = this.internal;
        if (thisStack.func_190926_b()) {
            return thatStack.func_190926_b();
        }
        if (thisStack.func_190916_E() != thatStack.func_190916_E()) {
            return false;
        }
        if (!Objects.equals(thisStack.func_77973_b(), thatStack.func_77973_b())) {
            return false;
        }
        if (!Objects.equals(thisStack.func_77978_p(), thatStack.func_77978_p())) {
            return false;
        }
        return thisStack.areCapsCompatible((CapabilityProvider)thatStack);
    }

    public int hashCode() {
        return Objects.hash(this.internal.func_190916_E(), this.internal.func_77973_b(), this.internal.func_77978_p());
    }
}

