/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.item;

import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker.api.brackets.CommandStringDisplayable;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="crafttweaker.api.item.MCWeightedItemStack")
@Document(value="vanilla/api/items/MCWeightedItemStack")
public class MCWeightedItemStack
implements CommandStringDisplayable {
    private final IItemStack itemStack;
    private final double weight;

    @ZenCodeType.Constructor
    public MCWeightedItemStack(IItemStack itemStack, double weight) {
        this.itemStack = itemStack;
        this.weight = weight;
    }

    @ZenCodeType.Getter(value="stack")
    public IItemStack getItemStack() {
        return this.itemStack;
    }

    @ZenCodeType.Getter(value="weight")
    public double getWeight() {
        return this.weight;
    }

    @ZenCodeType.Operator(value=ZenCodeType.OperatorType.MOD)
    public MCWeightedItemStack percent(int newWeight) {
        return this.weight((double)newWeight / 100.0);
    }

    @ZenCodeType.Operator(value=ZenCodeType.OperatorType.MUL)
    public MCWeightedItemStack setAmount(int newAmount) {
        return new MCWeightedItemStack(this.itemStack.setAmount(newAmount), this.weight);
    }

    @ZenCodeType.Method
    public MCWeightedItemStack weight(double newWeight) {
        return new MCWeightedItemStack(this.itemStack, newWeight);
    }

    @Override
    public String getCommandString() {
        return String.format("%s.weight(%sD);", this.itemStack.getCommandString(), this.weight);
    }

    public String toString() {
        return this.getCommandString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MCWeightedItemStack that = (MCWeightedItemStack)o;
        if (Double.compare(that.weight, this.weight) != 0) {
            return false;
        }
        return this.itemStack.equals(that.itemStack);
    }

    public int hashCode() {
        int result = this.itemStack.hashCode();
        long temp = Double.doubleToLongBits(this.weight);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }
}

