/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.misc;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.villagers.ITradeRemover;
import com.blamejared.crafttweaker.impl.actions.villagers.ActionAddTrade;
import com.blamejared.crafttweaker.impl.actions.villagers.ActionAddWanderingTrade;
import com.blamejared.crafttweaker.impl.actions.villagers.ActionRemoveTrade;
import com.blamejared.crafttweaker.impl.actions.villagers.ActionRemoveWanderingTrade;
import com.blamejared.crafttweaker.impl.item.MCItemStackMutable;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.entity.merchant.villager.VillagerTrades;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.BasicTrade;
import org.openzen.zencode.java.ZenCodeGlobals;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="crafttweaker.api.villagers.VillagerTrades")
@Document(value="vanilla/api/villager/VillagerTrades")
public class CTVillagerTrades {
    @ZenCodeGlobals.Global(value="villagerTrades")
    public static final CTVillagerTrades INSTANCE = new CTVillagerTrades();

    @ZenCodeType.Method
    public void addTrade(VillagerProfession profession, int villagerLevel, int emeralds, ItemStack forSale, int maxTrades, int xp, @ZenCodeType.OptionalFloat(value=1.0f) float priceMult) {
        BasicTrade trade = new BasicTrade(emeralds, forSale, maxTrades, xp, priceMult);
        this.addTradeInternal(profession, villagerLevel, trade);
    }

    @ZenCodeType.Method
    public void addTrade(VillagerProfession profession, int villagerLevel, ItemStack input1, ItemStack forSale, int maxTrades, int xp, @ZenCodeType.OptionalFloat(value=1.0f) float priceMult) {
        BasicTrade trade = new BasicTrade(input1, forSale, maxTrades, xp, priceMult);
        this.addTradeInternal(profession, villagerLevel, trade);
    }

    @ZenCodeType.Method
    public void addTrade(VillagerProfession profession, int villagerLevel, ItemStack input1, ItemStack input2, ItemStack forSale, int maxTrades, int xp, @ZenCodeType.OptionalFloat(value=1.0f) float priceMult) {
        BasicTrade trade = new BasicTrade(input1, input2, forSale, maxTrades, xp, priceMult);
        this.addTradeInternal(profession, villagerLevel, trade);
    }

    @ZenCodeType.Method
    public void removeEmeraldForItemsTrade(VillagerProfession profession, int villagerLevel, Item tradeFor) {
        this.removeTradeInternal(profession, villagerLevel, trade -> {
            if (trade instanceof VillagerTrades.EmeraldForItemsTrade) {
                return ((VillagerTrades.EmeraldForItemsTrade)trade).field_221183_a == tradeFor;
            }
            return false;
        });
    }

    @ZenCodeType.Method
    public void removeItemsForEmeraldsTrade(VillagerProfession profession, int villagerLevel, IItemStack sellingItem) {
        this.removeTradeInternal(profession, villagerLevel, trade -> {
            if (trade instanceof VillagerTrades.ItemsForEmeraldsTrade) {
                return sellingItem.matches(new MCItemStackMutable(((VillagerTrades.ItemsForEmeraldsTrade)trade).field_221208_a));
            }
            return false;
        });
    }

    @ZenCodeType.Method
    public void removeItemsForEmeraldsAndItemsTrade(VillagerProfession profession, int villagerLevel, IItemStack sellingItem, IItemStack buyingItem) {
        this.removeTradeInternal(profession, villagerLevel, trade -> {
            if (trade instanceof VillagerTrades.ItemsForEmeraldsAndItemsTrade && sellingItem.matches(new MCItemStackMutable(((VillagerTrades.ItemsForEmeraldsAndItemsTrade)trade).field_221203_d))) {
                return buyingItem.matches(new MCItemStackMutable(((VillagerTrades.ItemsForEmeraldsAndItemsTrade)trade).field_221200_a));
            }
            return false;
        });
    }

    @ZenCodeType.Method
    public void removeItemWithPotionForEmeraldsAndItemsTrade(VillagerProfession profession, int villagerLevel, IItemStack potionStack, Item sellingItem) {
        this.removeTradeInternal(profession, villagerLevel, trade -> {
            if (trade instanceof VillagerTrades.ItemWithPotionForEmeraldsAndItemsTrade && potionStack.matches(new MCItemStackMutable(((VillagerTrades.ItemWithPotionForEmeraldsAndItemsTrade)trade).field_221219_a))) {
                return sellingItem == ((VillagerTrades.ItemWithPotionForEmeraldsAndItemsTrade)trade).field_221224_f;
            }
            return false;
        });
    }

    @ZenCodeType.Method
    public void removeDyedArmorForEmeraldsTrade(VillagerProfession profession, int villagerLevel, Item buyingItem) {
        this.removeTradeInternal(profession, villagerLevel, trade -> {
            if (trade instanceof VillagerTrades.DyedArmorForEmeraldsTrade) {
                return ((VillagerTrades.DyedArmorForEmeraldsTrade)trade).field_221233_a == buyingItem;
            }
            return false;
        });
    }

    @ZenCodeType.Method
    public void removeEmeraldForMapTrade(VillagerProfession profession, int villagerLevel) {
        this.removeTradeInternal(profession, villagerLevel, trade -> trade instanceof VillagerTrades.EmeraldForMapTrade);
    }

    @ZenCodeType.Method
    public void removeEnchantedBookForEmeraldsTrade(VillagerProfession profession, int villagerLevel) {
        this.removeTradeInternal(profession, villagerLevel, trade -> trade instanceof VillagerTrades.EnchantedBookForEmeraldsTrade);
    }

    @ZenCodeType.Method
    public void removeEnchantedItemForEmeraldsTrade(VillagerProfession profession, int villagerLevel, IItemStack buyingItem) {
        this.removeTradeInternal(profession, villagerLevel, trade -> {
            if (trade instanceof VillagerTrades.EnchantedItemForEmeraldsTrade) {
                return buyingItem.matches(new MCItemStackMutable(((VillagerTrades.EnchantedItemForEmeraldsTrade)trade).field_221195_a));
            }
            return false;
        });
    }

    @ZenCodeType.Method
    public void removeSuspiciousStewForEmeraldTrade(VillagerProfession profession, int villagerLevel) {
        this.removeTradeInternal(profession, villagerLevel, trade -> trade instanceof VillagerTrades.SuspiciousStewForEmeraldTrade);
    }

    @ZenCodeType.Method
    public void addWanderingTrade(int rarity, int emeralds, ItemStack forSale, int maxTrades, int xp) {
        BasicTrade trade = new BasicTrade(emeralds, forSale, maxTrades, xp, 1.0f);
        this.addWanderingTradeInternal(rarity, trade);
    }

    @ZenCodeType.Method
    public void removeWanderingTrade(int rarity, IItemStack tradeFor) {
        this.removeWanderingTradeInternal(rarity, trade -> {
            if (trade instanceof VillagerTrades.ItemsForEmeraldsTrade) {
                return tradeFor.matches(new MCItemStackMutable(((VillagerTrades.ItemsForEmeraldsTrade)trade).field_221208_a));
            }
            return false;
        });
    }

    private void addTradeInternal(VillagerProfession profession, int villagerLevel, BasicTrade trade) {
        CraftTweakerAPI.apply(new ActionAddTrade(profession, villagerLevel, trade));
    }

    private void addWanderingTradeInternal(int villagerLevel, BasicTrade trade) {
        CraftTweakerAPI.apply(new ActionAddWanderingTrade(villagerLevel, trade));
    }

    private void removeTradeInternal(VillagerProfession profession, int villagerLevel, ITradeRemover remover) {
        CraftTweakerAPI.apply(new ActionRemoveTrade(profession, villagerLevel, remover));
    }

    private void removeWanderingTradeInternal(int villagerLevel, ITradeRemover remover) {
        CraftTweakerAPI.apply(new ActionRemoveWanderingTrade(villagerLevel, remover));
    }
}

