/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl_native.blocks;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import com.blamejared.crafttweaker_annotations.annotations.NativeTypeRegistration;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.state.Property;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@Document(value="vanilla/api/blocks/MCBlockState")
@NativeTypeRegistration(value=BlockState.class, zenCodeName="crafttweaker.api.blocks.MCBlockState")
public class ExpandBlockState {
    @ZenCodeType.Getter(value="block")
    @ZenCodeType.Caster(implicit=true)
    public static Block getBlock(BlockState internal) {
        return internal.func_177230_c();
    }

    @ZenCodeType.Getter(value="lightLevel")
    public static int getLightLevel(BlockState internal) {
        return internal.func_185906_d();
    }

    @ZenCodeType.Getter(value="canProvidePower")
    public static boolean canProvidePower(BlockState internal) {
        return internal.func_185897_m();
    }

    @ZenCodeType.Getter(value="isSolid")
    public static boolean isSolid(BlockState internal) {
        return internal.func_200132_m();
    }

    @ZenCodeType.Getter(value="ticksRandomly")
    public static boolean ticksRandomly(BlockState internal) {
        return internal.func_204519_t();
    }

    @ZenCodeType.Getter(value="hasTileEntity")
    public static boolean hasTileEntity(BlockState internal) {
        return internal.hasTileEntity();
    }

    @ZenCodeType.Getter(value="isSticky")
    public static boolean isSticky(BlockState internal) {
        return internal.isStickyBlock();
    }

    @ZenCodeType.Method
    public static BlockState withProperty(BlockState internal, String name, String value) {
        Property property = internal.func_177230_c().func_176194_O().func_185920_a(name);
        if (property == null) {
            CraftTweakerAPI.logWarning("Invalid property name", new Object[0]);
        } else {
            Optional propValue = property.func_185929_b(value);
            if (propValue.isPresent()) {
                return (BlockState)internal.func_206870_a(property, (Comparable)propValue.get());
            }
            CraftTweakerAPI.logWarning("Invalid property value", new Object[0]);
        }
        return internal;
    }

    @ZenCodeType.Method
    public static List<String> getPropertyNames(BlockState internal) {
        ArrayList<String> props = new ArrayList<String>();
        for (Property prop : internal.func_235904_r_()) {
            props.add(prop.func_177701_a());
        }
        return ImmutableList.copyOf(props);
    }

    @ZenCodeType.Method
    public static String getPropertyValue(BlockState internal, String name) {
        Property prop = internal.func_177230_c().func_176194_O().func_185920_a(name);
        if (prop != null) {
            return internal.func_177229_b(prop).toString();
        }
        CraftTweakerAPI.logWarning("Invalid property name", new Object[0]);
        return "";
    }

    @ZenCodeType.Method
    public static List<String> getAllowedValuesForProperty(BlockState internal, String name) {
        Property prop = internal.func_177230_c().func_176194_O().func_185920_a(name);
        if (prop != null) {
            ArrayList<String> values = new ArrayList<String>();
            prop.func_177700_c().forEach(v -> values.add(v.toString()));
            return values;
        }
        CraftTweakerAPI.logWarning("Invalid property name", new Object[0]);
        return ImmutableList.of();
    }

    @ZenCodeType.Method
    public static Map<String, String> getProperties(BlockState internal) {
        HashMap<String, String> props = new HashMap<String, String>();
        for (Property key : internal.func_235904_r_()) {
            props.put(key.func_177701_a(), internal.func_177229_b(key).toString());
        }
        return ImmutableMap.copyOf(props);
    }

    @ZenCodeType.Method
    public static boolean hasProperty(BlockState internal, String name) {
        Property prop = internal.func_177230_c().func_176194_O().func_185920_a(name);
        return prop != null;
    }

    @ZenCodeType.Caster
    public static String asString(BlockState internal) {
        return internal.toString();
    }

    @ZenCodeType.Getter(value="commandString")
    public static String getCommandString(BlockState internal) {
        StringBuilder builder = new StringBuilder("<blockstate:");
        builder.append(ExpandBlockState.getBlock(internal).getRegistryName());
        if (!ExpandBlockState.getProperties(internal).isEmpty()) {
            builder.append(":");
            builder.append(ExpandBlockState.getProperties(internal).entrySet().stream().map(kv -> (String)kv.getKey() + "=" + (String)kv.getValue()).collect(Collectors.joining(",")));
        }
        builder.append(">");
        return builder.toString();
    }
}

