/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl_native.world;

import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker.api.data.IData;
import com.blamejared.crafttweaker.api.data.NBTConverter;
import com.blamejared.crafttweaker.impl.data.MapData;
import com.blamejared.crafttweaker.impl.util.MCDirection;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import com.blamejared.crafttweaker_annotations.annotations.NativeTypeRegistration;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@Document(value="vanilla/api/world/MCWorld")
@NativeTypeRegistration(value=World.class, zenCodeName="crafttweaker.api.world.MCWorld")
public class ExpandWorld {
    @ZenCodeType.Getter(value="remote")
    @ZenCodeType.Method
    public static boolean isRemote(World internal) {
        return internal.field_72995_K;
    }

    @ZenCodeType.Getter(value="dayTime")
    public static boolean isDayTime(World internal) {
        return internal.func_72935_r();
    }

    @ZenCodeType.Getter(value="nightTime")
    public static boolean isNightTime(World internal) {
        return internal.func_226690_K_();
    }

    @ZenCodeType.Getter(value="gameTime")
    public static long getTime(World internal) {
        return internal.func_82737_E();
    }

    @ZenCodeType.Getter(value="seaLevel")
    public static int getSeaLevel(World internal) {
        return internal.func_181545_F();
    }

    @ZenCodeType.Getter(value="raining")
    public static boolean isRaining(World internal) {
        return internal.func_72896_J();
    }

    @ZenCodeType.Getter(value="thundering")
    public static boolean isThundering(World internal) {
        return internal.func_72911_I();
    }

    @ZenCodeType.Getter(value="hardcore")
    public static boolean isHardcore(World internal) {
        return internal.func_72912_H().func_76093_s();
    }

    @ZenCodeType.Getter(value="difficulty")
    public static String getDifficulty(World internal) {
        return internal.func_72912_H().func_176130_y().func_151526_b();
    }

    @ZenCodeType.Getter(value="difficultyLocked")
    public static boolean isDifficultyLocked(World internal) {
        return internal.func_72912_H().func_176123_z();
    }

    @ZenCodeType.Getter(value="dimension")
    public static String getDimension(World internal) {
        return internal.func_234923_W_().getRegistryName().toString();
    }

    @ZenCodeType.Method
    public static boolean isRainingAt(World internal, BlockPos pos) {
        return internal.func_175727_C(pos);
    }

    @ZenCodeType.Method
    public static int getStrongPower(World internal, BlockPos pos) {
        return internal.func_175676_y(pos);
    }

    @ZenCodeType.Method
    public static int getRedstonePower(World internal, BlockPos pos, MCDirection direction) {
        return internal.func_175651_c(pos, direction.getInternal());
    }

    @ZenCodeType.Method
    public static int getRedstonePowerFromNeighbors(World internal, BlockPos pos) {
        return internal.func_175687_A(pos);
    }

    @ZenCodeType.Method
    public static IData getTileData(World internal, BlockPos pos) {
        CompoundNBT nbt = new CompoundNBT();
        TileEntity te = internal.func_175625_s(pos);
        return te == null ? new MapData() : NBTConverter.convert((INBT)te.func_189515_b(nbt));
    }

    @ZenCodeType.Method
    public static boolean setBlockState(World internal, BlockPos pos, BlockState state) {
        return internal.func_175656_a(pos, state);
    }

    @ZenCodeType.Method
    public static BlockState getBlockState(World internal, BlockPos pos) {
        return internal.func_180495_p(pos);
    }

    @ZenCodeType.Method
    public static boolean isBlockPowered(World internal, BlockPos pos) {
        return internal.func_175640_z(pos);
    }

    @ZenCodeType.Method
    public static Biome getBiome(World internal, BlockPos pos) {
        return internal.func_226691_t_(pos);
    }
}

