/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zencode.java.module.converters;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import org.objectweb.asm.Type;
import org.openzen.zencode.java.ZenCodeType;
import org.openzen.zencode.java.module.JavaNativeTypeConversionContext;
import org.openzen.zencode.java.module.converters.JavaNativeHeaderConverter;
import org.openzen.zencode.java.module.converters.JavaNativeMemberConverter;
import org.openzen.zencode.java.module.converters.JavaNativePackageInfo;
import org.openzen.zencode.java.module.converters.JavaNativeTypeConverter;
import org.openzen.zencode.shared.CodePosition;
import org.openzen.zencode.shared.logging.IZSLogger;
import org.openzen.zenscript.codemodel.FunctionHeader;
import org.openzen.zenscript.codemodel.HighLevelDefinition;
import org.openzen.zenscript.codemodel.definition.ExpansionDefinition;
import org.openzen.zenscript.codemodel.member.CasterMember;
import org.openzen.zenscript.codemodel.member.GetterMember;
import org.openzen.zenscript.codemodel.member.MethodMember;
import org.openzen.zenscript.codemodel.type.TypeID;
import org.openzen.zenscript.javashared.JavaClass;
import org.openzen.zenscript.javashared.JavaMethod;

public class JavaNativeExpansionConverter {
    private final JavaNativeTypeConverter typeConverter;
    private final IZSLogger logger;
    private final JavaNativePackageInfo packageInfo;
    private final JavaNativeMemberConverter memberConverter;
    private final JavaNativeTypeConversionContext typeConversionContext;
    private final JavaNativeHeaderConverter headerConverter;

    public JavaNativeExpansionConverter(JavaNativeTypeConverter typeConverter, IZSLogger logger, JavaNativePackageInfo packageInfo, JavaNativeMemberConverter memberConverter, JavaNativeTypeConversionContext typeConversionContext, JavaNativeHeaderConverter headerConverter) {
        this.typeConverter = typeConverter;
        this.logger = logger;
        this.packageInfo = packageInfo;
        this.memberConverter = memberConverter;
        this.typeConversionContext = typeConversionContext;
        this.headerConverter = headerConverter;
    }

    public ExpansionDefinition convertExpansion(Class<?> cls) {
        if (this.doesClassNotHaveAnnotation(cls)) {
            throw new IllegalArgumentException("Cannot convert class " + cls + " as it does not have an Expansion annotation");
        }
        String expandedName = this.getExpandedName(cls);
        TypeID expandedType = this.typeConverter.getTypeFromName(expandedName);
        if (expandedType == null) {
            throw new IllegalArgumentException("Could not find definition for name " + expandedName);
        }
        ExpansionDefinition expansion = new ExpansionDefinition(CodePosition.NATIVE, this.packageInfo.getModule(), this.packageInfo.getPkg(), 1, null);
        JavaClass javaClass = JavaClass.fromInternalName(Type.getInternalName(cls), JavaClass.Kind.CLASS);
        expansion.target = expandedType;
        this.typeConversionContext.definitionByClass.put(cls, expansion);
        this.fillAnnotatedMethods(cls, expandedType, expansion, javaClass);
        if (!expansion.members.isEmpty()) {
            this.typeConversionContext.compiled.setExpansionClassInfo(expansion, javaClass);
            this.typeConversionContext.packageDefinitions.add(expansion);
        }
        return expansion;
    }

    private void fillAnnotatedMethods(Class<?> cls, TypeID expandedType, ExpansionDefinition expansion, JavaClass javaClass) {
        for (Method method : cls.getDeclaredMethods()) {
            ZenCodeType.Caster casterAnnotation;
            ZenCodeType.Getter getterAnnotation;
            ZenCodeType.Method methodAnnotation;
            if (!Modifier.isStatic(method.getModifiers()) || method.getParameterCount() < 1) continue;
            Class<?> classFromType = this.typeConverter.getClassFromType(expandedType);
            if (classFromType == null) {
                this.logger.debug("Could not get class for type " + expandedType + " attempting to do stuff anyways");
            }
            if ((methodAnnotation = this.getMethodAnnotation(method, ZenCodeType.Method.class)) != null) {
                this.fillMethod(expansion, javaClass, method, classFromType, methodAnnotation);
            }
            if ((getterAnnotation = this.getMethodAnnotation(method, ZenCodeType.Getter.class)) != null) {
                this.fillGetter(expansion, javaClass, method, classFromType, getterAnnotation);
            }
            if ((casterAnnotation = this.getMethodAnnotation(method, ZenCodeType.Caster.class)) == null) continue;
            this.fillCaster(expansion, javaClass, method, classFromType, casterAnnotation);
        }
    }

    private void fillCaster(ExpansionDefinition expansion, JavaClass javaClass, Method method, Class<?> classFromType, ZenCodeType.Caster casterAnnotation) {
        this.checkExpandedType(classFromType, method);
        boolean implicit = casterAnnotation.implicit();
        int modifiers = this.headerConverter.getMethodModifiers(method) ^ 0x80;
        if (implicit) {
            modifiers |= 0x200;
        }
        TypeID toType = this.typeConverter.loadStoredType(this.typeConversionContext.context, method.getAnnotatedReturnType());
        CasterMember member = new CasterMember(CodePosition.NATIVE, (HighLevelDefinition)expansion, modifiers, toType, null);
        expansion.addMember(member);
        this.typeConversionContext.compiled.setMethodInfo(member, this.memberConverter.getMethod(javaClass, method, member.toType));
    }

    private void fillGetter(ExpansionDefinition expansion, JavaClass javaClass, Method method, Class<?> classFromType, ZenCodeType.Getter getterAnnotation) {
        this.checkExpandedType(classFromType, method);
        TypeID type = this.typeConverter.loadStoredType(this.typeConversionContext.context, method.getAnnotatedReturnType());
        int modifiers = this.headerConverter.getMethodModifiers(method) ^ 0x80;
        String name = getterAnnotation.value().isEmpty() ? this.memberConverter.translateGetterName(method.getName()) : getterAnnotation.value();
        GetterMember member = new GetterMember(CodePosition.NATIVE, expansion, modifiers, name, type, null);
        expansion.addMember(member);
        this.typeConversionContext.compiled.setMethodInfo(member, this.memberConverter.getMethod(javaClass, method, type));
    }

    private void fillMethod(ExpansionDefinition expansion, JavaClass javaClass, Method method, Class<?> classFromType, ZenCodeType.Method methodAnnotation) {
        this.checkExpandedType(classFromType, method);
        String name = !methodAnnotation.value().isEmpty() ? methodAnnotation.value() : method.getName();
        Parameter[] parameters = this.getExpansionParameters(method);
        FunctionHeader header = this.headerConverter.getHeader(this.typeConversionContext.context, method.getAnnotatedReturnType(), parameters, method.getTypeParameters(), method.getAnnotatedExceptionTypes());
        MethodMember member = new MethodMember(CodePosition.NATIVE, expansion, this.headerConverter.getMethodModifiers(method) ^ 0x80, name, header, null);
        expansion.addMember(member);
        this.typeConversionContext.compiled.setMethodInfo(member, JavaMethod.getStatic(javaClass, name, Type.getMethodDescriptor((Method)method), this.headerConverter.getMethodModifiers(method)));
    }

    protected String getExpandedName(Class<?> cls) {
        return cls.getAnnotation(ZenCodeType.Expansion.class).value();
    }

    protected boolean doesClassNotHaveAnnotation(Class<?> cls) {
        return !cls.isAnnotationPresent(ZenCodeType.Expansion.class);
    }

    private void checkExpandedType(Class<?> clsType, Method method) {
        if (clsType == null) {
            return;
        }
        if (!method.getParameterTypes()[0].isAssignableFrom(clsType)) {
            throw new IllegalArgumentException("Cannot add extension method " + method + " as its first parameter does not match the extended type.");
        }
    }

    private Parameter[] getExpansionParameters(Method method) {
        Parameter[] parameters = new Parameter[method.getParameterCount() - 1];
        System.arraycopy(method.getParameters(), 1, parameters, 0, method.getParameterCount() - 1);
        return parameters;
    }

    protected <T extends Annotation> T getMethodAnnotation(Method method, Class<T> annotationClass) {
        return method.getAnnotation(annotationClass);
    }
}

