/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zencode.java.module.converters;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.objectweb.asm.Type;
import org.openzen.zencode.java.ZenCodeGlobals;
import org.openzen.zencode.java.ZenCodeType;
import org.openzen.zencode.java.module.JavaNativeTypeConversionContext;
import org.openzen.zencode.java.module.converters.JavaNativeMemberConverter;
import org.openzen.zencode.java.module.converters.JavaNativeTypeConverter;
import org.openzen.zencode.shared.CodePosition;
import org.openzen.zenscript.codemodel.GenericMapper;
import org.openzen.zenscript.codemodel.HighLevelDefinition;
import org.openzen.zenscript.codemodel.expression.ExpressionSymbol;
import org.openzen.zenscript.codemodel.expression.StaticGetterExpression;
import org.openzen.zenscript.codemodel.member.FieldMember;
import org.openzen.zenscript.codemodel.member.MethodMember;
import org.openzen.zenscript.codemodel.partial.PartialStaticMemberGroupExpression;
import org.openzen.zenscript.codemodel.scope.TypeScope;
import org.openzen.zenscript.codemodel.type.DefinitionTypeID;
import org.openzen.zenscript.codemodel.type.TypeID;
import org.openzen.zenscript.codemodel.type.member.TypeMembers;
import org.openzen.zenscript.javashared.JavaClass;
import org.openzen.zenscript.javashared.JavaField;

public class JavaNativeGlobalConverter {
    private final JavaNativeTypeConversionContext typeConversionContext;
    private final JavaNativeTypeConverter typeConverter;
    private final JavaNativeMemberConverter memberConverter;

    public JavaNativeGlobalConverter(JavaNativeTypeConversionContext typeConversionContext, JavaNativeTypeConverter typeConverter, JavaNativeMemberConverter memberConverter) {
        this.typeConversionContext = typeConversionContext;
        this.typeConverter = typeConverter;
        this.memberConverter = memberConverter;
    }

    public void addGlobal(Class<?> cls, HighLevelDefinition definition) {
        ZenCodeGlobals.Global global;
        JavaClass jcls;
        if (this.typeConversionContext.compiled.hasClassInfo(definition)) {
            jcls = this.typeConversionContext.compiled.getClassInfo(definition);
        } else {
            jcls = JavaClass.fromInternalName(Type.getInternalName(cls), JavaClass.Kind.CLASS);
            this.typeConversionContext.compiled.setClassInfo(definition, jcls);
        }
        DefinitionTypeID thisType = this.typeConversionContext.registry.getForMyDefinition(definition);
        for (Field field : cls.getDeclaredFields()) {
            if (!field.isAnnotationPresent(ZenCodeGlobals.Global.class) || !Modifier.isStatic(field.getModifiers())) continue;
            global = field.getAnnotation(ZenCodeGlobals.Global.class);
            TypeID type = this.typeConverter.loadStoredType(this.typeConversionContext.context, field.getAnnotatedType());
            String name = global.value().isEmpty() ? field.getName() : global.value();
            FieldMember fieldMember = new FieldMember(CodePosition.NATIVE, definition, 129, name, (TypeID)thisType, type, this.typeConversionContext.registry, 1, 0, null);
            definition.addMember(fieldMember);
            JavaField javaField = new JavaField(jcls, field.getName(), Type.getDescriptor(field.getType()));
            this.typeConversionContext.compiled.setFieldInfo(fieldMember, javaField);
            this.typeConversionContext.compiled.setFieldInfo(fieldMember.autoGetter, javaField);
            this.typeConversionContext.globals.put(name, new ExpressionSymbol((position, scope) -> new StaticGetterExpression(CodePosition.BUILTIN, fieldMember.autoGetter.ref(thisType, GenericMapper.EMPTY))));
        }
        for (AccessibleObject accessibleObject : cls.getDeclaredMethods()) {
            if (!accessibleObject.isAnnotationPresent(ZenCodeGlobals.Global.class) || !Modifier.isStatic(((Method)accessibleObject).getModifiers())) continue;
            global = ((Method)accessibleObject).getAnnotation(ZenCodeGlobals.Global.class);
            final String name = global.value().isEmpty() ? ((Method)accessibleObject).getName() : global.value();
            MethodMember methodMember = this.memberConverter.asMethod(this.typeConversionContext.context, definition, (Method)accessibleObject, new ZenCodeType.Method(){

                @Override
                public String value() {
                    return name;
                }

                @Override
                public Class<? extends Annotation> annotationType() {
                    return ZenCodeType.Method.class;
                }
            });
            definition.addMember(methodMember);
            this.typeConversionContext.compiled.setMethodInfo(methodMember, this.memberConverter.getMethod(jcls, (Method)accessibleObject, this.typeConverter.loadType(this.typeConversionContext.context, ((Method)accessibleObject).getAnnotatedReturnType())));
            this.typeConversionContext.globals.put(name, new ExpressionSymbol((position, scope) -> {
                TypeMembers members = scope.getTypeMembers(thisType);
                return new PartialStaticMemberGroupExpression((CodePosition)position, (TypeScope)scope, thisType, members.getGroup(name), TypeID.NONE);
            }));
        }
    }
}

