/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zenscript.parser.expression;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.openzen.zencode.shared.CodePosition;
import org.openzen.zencode.shared.CompileException;
import org.openzen.zencode.shared.CompileExceptionCode;
import org.openzen.zencode.shared.StringExpansion;
import org.openzen.zenscript.codemodel.CompareType;
import org.openzen.zenscript.codemodel.OperatorType;
import org.openzen.zenscript.codemodel.expression.Expression;
import org.openzen.zenscript.codemodel.expression.switchvalue.SwitchValue;
import org.openzen.zenscript.codemodel.partial.IPartialExpression;
import org.openzen.zenscript.codemodel.scope.BaseScope;
import org.openzen.zenscript.codemodel.scope.ExpressionScope;
import org.openzen.zenscript.codemodel.type.TypeID;
import org.openzen.zenscript.lexer.ParseException;
import org.openzen.zenscript.lexer.ZSToken;
import org.openzen.zenscript.lexer.ZSTokenParser;
import org.openzen.zenscript.lexer.ZSTokenType;
import org.openzen.zenscript.parser.definitions.ParsedFunctionHeader;
import org.openzen.zenscript.parser.definitions.ParsedFunctionParameter;
import org.openzen.zenscript.parser.expression.ParsedCallArguments;
import org.openzen.zenscript.parser.expression.ParsedDollarExpression;
import org.openzen.zenscript.parser.expression.ParsedExpressionAndAnd;
import org.openzen.zenscript.parser.expression.ParsedExpressionArray;
import org.openzen.zenscript.parser.expression.ParsedExpressionAssign;
import org.openzen.zenscript.parser.expression.ParsedExpressionBinary;
import org.openzen.zenscript.parser.expression.ParsedExpressionBool;
import org.openzen.zenscript.parser.expression.ParsedExpressionBracket;
import org.openzen.zenscript.parser.expression.ParsedExpressionCall;
import org.openzen.zenscript.parser.expression.ParsedExpressionCast;
import org.openzen.zenscript.parser.expression.ParsedExpressionCoalesce;
import org.openzen.zenscript.parser.expression.ParsedExpressionCompare;
import org.openzen.zenscript.parser.expression.ParsedExpressionConditional;
import org.openzen.zenscript.parser.expression.ParsedExpressionFloat;
import org.openzen.zenscript.parser.expression.ParsedExpressionFunction;
import org.openzen.zenscript.parser.expression.ParsedExpressionIndex;
import org.openzen.zenscript.parser.expression.ParsedExpressionInt;
import org.openzen.zenscript.parser.expression.ParsedExpressionIs;
import org.openzen.zenscript.parser.expression.ParsedExpressionMap;
import org.openzen.zenscript.parser.expression.ParsedExpressionMember;
import org.openzen.zenscript.parser.expression.ParsedExpressionNull;
import org.openzen.zenscript.parser.expression.ParsedExpressionOpAssign;
import org.openzen.zenscript.parser.expression.ParsedExpressionOrOr;
import org.openzen.zenscript.parser.expression.ParsedExpressionOuter;
import org.openzen.zenscript.parser.expression.ParsedExpressionPostCall;
import org.openzen.zenscript.parser.expression.ParsedExpressionRange;
import org.openzen.zenscript.parser.expression.ParsedExpressionSame;
import org.openzen.zenscript.parser.expression.ParsedExpressionString;
import org.openzen.zenscript.parser.expression.ParsedExpressionSuper;
import org.openzen.zenscript.parser.expression.ParsedExpressionThis;
import org.openzen.zenscript.parser.expression.ParsedExpressionUnary;
import org.openzen.zenscript.parser.expression.ParsedExpressionVariable;
import org.openzen.zenscript.parser.expression.ParsedLocalVariableExpression;
import org.openzen.zenscript.parser.expression.ParsedMatchExpression;
import org.openzen.zenscript.parser.expression.ParsedNewExpression;
import org.openzen.zenscript.parser.expression.ParsedPanicExpression;
import org.openzen.zenscript.parser.expression.ParsedThrowExpression;
import org.openzen.zenscript.parser.expression.ParsedTryConvertExpression;
import org.openzen.zenscript.parser.expression.ParsedTryRethrowExpression;
import org.openzen.zenscript.parser.expression.ParsedTypeExpression;
import org.openzen.zenscript.parser.statements.ParsedFunctionBody;
import org.openzen.zenscript.parser.statements.ParsedStatement;
import org.openzen.zenscript.parser.type.IParsedType;

public abstract class ParsedExpression {
    public final CodePosition position;

    public ParsedExpression(CodePosition position) {
        this.position = position;
    }

    public static ParsedExpression parse(ZSTokenParser parser) throws ParseException {
        return ParsedExpression.readAssignExpression(parser, ParsingOptions.DEFAULT);
    }

    public static ParsedExpression parse(ZSTokenParser parser, ParsingOptions options) throws ParseException {
        return ParsedExpression.readAssignExpression(parser, options);
    }

    private static ParsedExpression readAssignExpression(ZSTokenParser parser, ParsingOptions options) throws ParseException {
        CodePosition position = parser.getPosition();
        ParsedExpression left = ParsedExpression.readConditionalExpression(position, parser, options);
        switch (((ZSToken)parser.peek()).type) {
            case T_ASSIGN: {
                parser.next();
                return new ParsedExpressionAssign(position, left, ParsedExpression.readAssignExpression(parser, options));
            }
            case T_ADDASSIGN: {
                parser.next();
                return new ParsedExpressionOpAssign(position, left, ParsedExpression.readAssignExpression(parser, options), OperatorType.ADDASSIGN);
            }
            case T_SUBASSIGN: {
                parser.next();
                return new ParsedExpressionOpAssign(position, left, ParsedExpression.readAssignExpression(parser, options), OperatorType.SUBASSIGN);
            }
            case T_CATASSIGN: {
                parser.next();
                return new ParsedExpressionOpAssign(position, left, ParsedExpression.readAssignExpression(parser, options), OperatorType.CATASSIGN);
            }
            case T_MULASSIGN: {
                parser.next();
                return new ParsedExpressionOpAssign(position, left, ParsedExpression.readAssignExpression(parser, options), OperatorType.MULASSIGN);
            }
            case T_DIVASSIGN: {
                parser.next();
                return new ParsedExpressionOpAssign(position, left, ParsedExpression.readAssignExpression(parser, options), OperatorType.DIVASSIGN);
            }
            case T_MODASSIGN: {
                parser.next();
                return new ParsedExpressionOpAssign(position, left, ParsedExpression.readAssignExpression(parser, options), OperatorType.MODASSIGN);
            }
            case T_ORASSIGN: {
                parser.next();
                return new ParsedExpressionOpAssign(position, left, ParsedExpression.readAssignExpression(parser, options), OperatorType.ORASSIGN);
            }
            case T_ANDASSIGN: {
                parser.next();
                return new ParsedExpressionOpAssign(position, left, ParsedExpression.readAssignExpression(parser, options), OperatorType.ANDASSIGN);
            }
            case T_XORASSIGN: {
                parser.next();
                return new ParsedExpressionOpAssign(position, left, ParsedExpression.readAssignExpression(parser, options), OperatorType.XORASSIGN);
            }
            case T_SHLASSIGN: {
                parser.next();
                return new ParsedExpressionOpAssign(position, left, ParsedExpression.readAssignExpression(parser, options), OperatorType.SHLASSIGN);
            }
            case T_SHRASSIGN: {
                parser.next();
                return new ParsedExpressionOpAssign(position, left, ParsedExpression.readAssignExpression(parser, options), OperatorType.SHRASSIGN);
            }
            case T_USHRASSIGN: {
                parser.next();
                return new ParsedExpressionOpAssign(position, left, ParsedExpression.readAssignExpression(parser, options), OperatorType.USHRASSIGN);
            }
        }
        return left;
    }

    private static ParsedExpression readConditionalExpression(CodePosition position, ZSTokenParser parser, ParsingOptions options) throws ParseException {
        ParsedExpression left = ParsedExpression.readOrOrExpression(position, parser, options);
        if (parser.optional(ZSTokenType.T_QUEST) != null) {
            ParsedExpression onIf = ParsedExpression.readOrOrExpression(parser.getPosition(), parser, options);
            parser.required(ZSTokenType.T_COLON, ": expected");
            ParsedExpression onElse = ParsedExpression.readConditionalExpression(parser.getPosition(), parser, options);
            return new ParsedExpressionConditional(position, left, onIf, onElse);
        }
        return left;
    }

    private static ParsedExpression readOrOrExpression(CodePosition position, ZSTokenParser parser, ParsingOptions options) throws ParseException {
        ParsedExpression right;
        ParsedExpression left = ParsedExpression.readAndAndExpression(position, parser, options);
        while (parser.optional(ZSTokenType.T_OROR) != null) {
            right = ParsedExpression.readAndAndExpression(parser.getPosition(), parser, options);
            left = new ParsedExpressionOrOr(position, left, right);
        }
        while (parser.optional(ZSTokenType.T_COALESCE) != null) {
            right = ParsedExpression.readAndAndExpression(parser.getPosition(), parser, options);
            left = new ParsedExpressionCoalesce(position, left, right);
        }
        return left;
    }

    private static ParsedExpression readAndAndExpression(CodePosition position, ZSTokenParser parser, ParsingOptions options) throws ParseException {
        ParsedExpression left = ParsedExpression.readOrExpression(position, parser, options);
        while (parser.optional(ZSTokenType.T_ANDAND) != null) {
            ParsedExpression right = ParsedExpression.readOrExpression(parser.getPosition(), parser, options);
            left = new ParsedExpressionAndAnd(position, left, right);
        }
        return left;
    }

    private static ParsedExpression readOrExpression(CodePosition position, ZSTokenParser parser, ParsingOptions options) throws ParseException {
        ParsedExpression left = ParsedExpression.readXorExpression(position, parser, options);
        while (parser.optional(ZSTokenType.T_OR) != null) {
            ParsedExpression right = ParsedExpression.readXorExpression(parser.getPosition(), parser, options);
            left = new ParsedExpressionBinary(position, left, right, OperatorType.OR);
        }
        return left;
    }

    private static ParsedExpression readXorExpression(CodePosition position, ZSTokenParser parser, ParsingOptions options) throws ParseException {
        ParsedExpression left = ParsedExpression.readAndExpression(position, parser, options);
        while (parser.optional(ZSTokenType.T_XOR) != null) {
            ParsedExpression right = ParsedExpression.readAndExpression(parser.getPosition(), parser, options);
            left = new ParsedExpressionBinary(position, left, right, OperatorType.XOR);
        }
        return left;
    }

    private static ParsedExpression readAndExpression(CodePosition position, ZSTokenParser parser, ParsingOptions options) throws ParseException {
        ParsedExpression left = ParsedExpression.readCompareExpression(position, parser, options);
        while (parser.optional(ZSTokenType.T_AND) != null) {
            ParsedExpression right = ParsedExpression.readCompareExpression(parser.getPosition(), parser, options);
            left = new ParsedExpressionBinary(position, left, right, OperatorType.AND);
        }
        return left;
    }

    private static ParsedExpression readCompareExpression(CodePosition position, ZSTokenParser parser, ParsingOptions options) throws ParseException {
        ParsedExpression left = ParsedExpression.readShiftExpression(position, parser, options);
        switch (((ZSToken)parser.peek()).getType()) {
            case T_EQUAL2: {
                parser.next();
                ParsedExpression right = ParsedExpression.readShiftExpression(parser.getPosition(), parser, options);
                return new ParsedExpressionCompare(position, left, right, CompareType.EQ);
            }
            case T_EQUAL3: {
                parser.next();
                ParsedExpression right = ParsedExpression.readShiftExpression(parser.getPosition(), parser, options);
                return new ParsedExpressionSame(position, left, right, false);
            }
            case T_NOTEQUAL: {
                parser.next();
                ParsedExpression right = ParsedExpression.readShiftExpression(parser.getPosition(), parser, options);
                return new ParsedExpressionCompare(position, left, right, CompareType.NE);
            }
            case T_NOTEQUAL2: {
                parser.next();
                ParsedExpression right = ParsedExpression.readShiftExpression(parser.getPosition(), parser, options);
                return new ParsedExpressionSame(position, left, right, true);
            }
            case T_LESS: {
                parser.next();
                ParsedExpression right = ParsedExpression.readShiftExpression(parser.getPosition(), parser, options);
                return new ParsedExpressionCompare(position, left, right, CompareType.LT);
            }
            case T_LESSEQ: {
                parser.next();
                ParsedExpression right = ParsedExpression.readShiftExpression(parser.getPosition(), parser, options);
                return new ParsedExpressionCompare(position, left, right, CompareType.LE);
            }
            case T_GREATER: {
                parser.next();
                ParsedExpression right = ParsedExpression.readShiftExpression(parser.getPosition(), parser, options);
                return new ParsedExpressionCompare(position, left, right, CompareType.GT);
            }
            case T_GREATEREQ: {
                parser.next();
                ParsedExpression right = ParsedExpression.readShiftExpression(parser.getPosition(), parser, options);
                return new ParsedExpressionCompare(position, left, right, CompareType.GE);
            }
            case K_IN: {
                parser.next();
                ParsedExpression right = ParsedExpression.readShiftExpression(parser.getPosition(), parser, options);
                return new ParsedExpressionBinary(position, right, left, OperatorType.CONTAINS);
            }
            case K_IS: {
                parser.next();
                IParsedType type = IParsedType.parse(parser);
                return new ParsedExpressionIs(position, left, type);
            }
            case T_NOT: {
                parser.next();
                if (parser.optional(ZSTokenType.K_IN) != null) {
                    ParsedExpression right = ParsedExpression.readShiftExpression(parser.getPosition(), parser, options);
                    return new ParsedExpressionUnary(position, new ParsedExpressionBinary(position, right, left, OperatorType.CONTAINS), OperatorType.NOT);
                }
                if (parser.optional(ZSTokenType.K_IS) != null) {
                    IParsedType type = IParsedType.parse(parser);
                    return new ParsedExpressionUnary(position, new ParsedExpressionIs(position, left, type), OperatorType.NOT);
                }
                throw new ParseException(position, "Expected in or is");
            }
        }
        return left;
    }

    private static ParsedExpression readShiftExpression(CodePosition position, ZSTokenParser parser, ParsingOptions options) throws ParseException {
        ParsedExpression left = ParsedExpression.readAddExpression(position, parser, options);
        while (true) {
            ParsedExpression right;
            if (parser.optional(ZSTokenType.T_SHL) != null) {
                right = ParsedExpression.readAddExpression(parser.getPosition(), parser, options);
                left = new ParsedExpressionBinary(position, left, right, OperatorType.SHL);
                continue;
            }
            if (parser.optional(ZSTokenType.T_SHR) != null) {
                right = ParsedExpression.readAddExpression(parser.getPosition(), parser, options);
                left = new ParsedExpressionBinary(position, left, right, OperatorType.SHR);
                continue;
            }
            if (parser.optional(ZSTokenType.T_USHR) == null) break;
            right = ParsedExpression.readAddExpression(parser.getPosition(), parser, options);
            left = new ParsedExpressionBinary(position, left, right, OperatorType.USHR);
        }
        return left;
    }

    private static ParsedExpression readAddExpression(CodePosition position, ZSTokenParser parser, ParsingOptions options) throws ParseException {
        ParsedExpression left = ParsedExpression.readMulExpression(position, parser, options);
        while (true) {
            ParsedExpression right;
            if (parser.optional(ZSTokenType.T_ADD) != null) {
                right = ParsedExpression.readMulExpression(parser.getPosition(), parser, options);
                left = new ParsedExpressionBinary(position, left, right, OperatorType.ADD);
                continue;
            }
            if (parser.optional(ZSTokenType.T_SUB) != null) {
                right = ParsedExpression.readMulExpression(parser.getPosition(), parser, options);
                left = new ParsedExpressionBinary(position, left, right, OperatorType.SUB);
                continue;
            }
            if (parser.optional(ZSTokenType.T_CAT) == null) break;
            right = ParsedExpression.readMulExpression(parser.getPosition(), parser, options);
            left = new ParsedExpressionBinary(position, left, right, OperatorType.CAT);
        }
        return left;
    }

    private static ParsedExpression readMulExpression(CodePosition position, ZSTokenParser parser, ParsingOptions options) throws ParseException {
        ParsedExpression left = ParsedExpression.readUnaryExpression(position, parser, options);
        while (true) {
            ParsedExpression right;
            if (parser.optional(ZSTokenType.T_MUL) != null) {
                right = ParsedExpression.readUnaryExpression(parser.getPosition(), parser, options);
                left = new ParsedExpressionBinary(position, left, right, OperatorType.MUL);
                continue;
            }
            if (parser.optional(ZSTokenType.T_DIV) != null) {
                right = ParsedExpression.readUnaryExpression(parser.getPosition(), parser, options);
                left = new ParsedExpressionBinary(position, left, right, OperatorType.DIV);
                continue;
            }
            if (parser.optional(ZSTokenType.T_MOD) == null) break;
            right = ParsedExpression.readUnaryExpression(parser.getPosition(), parser, options);
            left = new ParsedExpressionBinary(position, left, right, OperatorType.MOD);
        }
        return left;
    }

    private static ParsedExpression readUnaryExpression(CodePosition position, ZSTokenParser parser, ParsingOptions options) throws ParseException {
        switch (((ZSToken)parser.peek()).getType()) {
            case T_NOT: {
                parser.next();
                return new ParsedExpressionUnary(position, ParsedExpression.readUnaryExpression(parser.getPosition(), parser, options), OperatorType.NOT);
            }
            case T_SUB: {
                parser.next();
                return new ParsedExpressionUnary(position, ParsedExpression.readUnaryExpression(parser.getPosition(), parser, options), OperatorType.NEG);
            }
            case T_CAT: {
                parser.next();
                return new ParsedExpressionUnary(position, ParsedExpression.readUnaryExpression(parser.getPosition(), parser, options), OperatorType.CAT);
            }
            case T_INCREMENT: {
                parser.next();
                return new ParsedExpressionUnary(position, ParsedExpression.readUnaryExpression(parser.getPosition(), parser, options), OperatorType.INCREMENT);
            }
            case T_DECREMENT: {
                parser.next();
                return new ParsedExpressionUnary(position, ParsedExpression.readUnaryExpression(parser.getPosition(), parser, options), OperatorType.DECREMENT);
            }
            case K_TRY: {
                parser.next();
                if (parser.optional(ZSTokenType.T_QUEST) != null) {
                    return new ParsedTryConvertExpression(position, ParsedExpression.readUnaryExpression(position, parser, options));
                }
                if (parser.optional(ZSTokenType.T_NOT) == null) break;
                return new ParsedTryRethrowExpression(position, ParsedExpression.readUnaryExpression(position, parser, options));
            }
        }
        return ParsedExpression.readPostfixExpression(position, parser, options);
    }

    private static ParsedExpression readPostfixExpression(CodePosition position, ZSTokenParser parser, ParsingOptions options) throws ParseException {
        ParsedExpression base = ParsedExpression.readPrimaryExpression(position, parser, options);
        while (true) {
            if (parser.optional(ZSTokenType.T_DOT) != null) {
                ZSToken indexString = (ZSToken)parser.optional(ZSTokenType.T_IDENTIFIER);
                if (indexString != null) {
                    List<IParsedType> genericParameters = IParsedType.parseTypeArguments(parser);
                    base = new ParsedExpressionMember(position.until(parser.getPositionBeforeWhitespace()), base, indexString.content, genericParameters);
                    continue;
                }
                if (parser.optional(ZSTokenType.T_DOLLAR) != null) {
                    base = new ParsedExpressionOuter(position.until(parser.getPositionBeforeWhitespace()), base);
                    continue;
                }
                ZSToken indexString2 = (ZSToken)parser.optional(ZSTokenType.T_STRING_SQ);
                if (indexString2 == null) {
                    indexString2 = (ZSToken)parser.optional(ZSTokenType.T_STRING_DQ);
                }
                if (indexString2 != null) {
                    base = new ParsedExpressionMember(position.until(parser.getPositionBeforeWhitespace()), base, StringExpansion.unescape(indexString2.content).orElse("INVALID STRING"), Collections.emptyList());
                    continue;
                }
                position = parser.getPosition();
                ZSToken last = (ZSToken)parser.next();
                throw new ParseException(position.until(parser.getPositionBeforeWhitespace()), "Invalid expression, last token: " + last.content);
            }
            if (parser.optional(ZSTokenType.T_DOT2) != null) {
                ParsedExpression to = ParsedExpression.readAssignExpression(parser, options);
                return new ParsedExpressionRange(position.until(parser.getPositionBeforeWhitespace()), base, to);
            }
            if (parser.optional(ZSTokenType.T_SQOPEN) != null) {
                ArrayList<ParsedExpression> indexes = new ArrayList<ParsedExpression>();
                do {
                    indexes.add(ParsedExpression.readAssignExpression(parser, options));
                } while (parser.optional(ZSTokenType.T_COMMA) != null);
                parser.required(ZSTokenType.T_SQCLOSE, "] expected");
                base = new ParsedExpressionIndex(position, base, indexes);
                continue;
            }
            if (parser.isNext(ZSTokenType.T_BROPEN)) {
                base = new ParsedExpressionCall(position, base, ParsedCallArguments.parse(parser));
                continue;
            }
            if (parser.optional(ZSTokenType.K_AS) != null) {
                boolean optional = parser.optional(ZSTokenType.T_QUEST) != null;
                IParsedType type = IParsedType.parse(parser);
                base = new ParsedExpressionCast(position, base, type, optional);
                continue;
            }
            if (parser.optional(ZSTokenType.T_INCREMENT) != null) {
                base = new ParsedExpressionPostCall(position, base, OperatorType.INCREMENT);
                continue;
            }
            if (parser.optional(ZSTokenType.T_DECREMENT) != null) {
                base = new ParsedExpressionPostCall(position, base, OperatorType.DECREMENT);
                continue;
            }
            if (!options.allowLambda || parser.optional(ZSTokenType.T_LAMBDA) == null) break;
            ParsedFunctionBody body = ParsedStatement.parseLambdaBody(parser, true);
            base = new ParsedExpressionFunction(position, base.toLambdaHeader(), body);
        }
        return base;
    }

    private static ParsedExpression readPrimaryExpression(CodePosition position, ZSTokenParser parser, ParsingOptions options) throws ParseException {
        switch (((ZSToken)parser.peek()).getType()) {
            case T_INT: {
                return new ParsedExpressionInt(position, ((ZSToken)parser.next()).content);
            }
            case T_PREFIXED_INT: {
                return ParsedExpressionInt.parsePrefixed(position, ((ZSToken)parser.next()).content);
            }
            case T_FLOAT: {
                return new ParsedExpressionFloat(position, ((ZSToken)parser.next()).content);
            }
            case T_STRING_SQ: 
            case T_STRING_DQ: {
                String quoted = ((ZSToken)parser.next()).content;
                return new ParsedExpressionString(position, StringExpansion.unescape(quoted).orElse(error -> "INVALID_STRING"), quoted.charAt(0) == '\'');
            }
            case T_IDENTIFIER: {
                String name = ((ZSToken)parser.next()).content;
                if (name.startsWith("@")) {
                    name = name.substring(1);
                }
                List<IParsedType> genericParameters = IParsedType.parseTypeArguments(parser);
                return new ParsedExpressionVariable(position.until(parser.getPositionBeforeWhitespace()), name, genericParameters);
            }
            case T_LOCAL_IDENTIFIER: {
                String name = ((ZSToken)parser.next()).content.substring(1);
                return new ParsedLocalVariableExpression(position, name);
            }
            case K_THIS: {
                parser.next();
                return new ParsedExpressionThis(position);
            }
            case K_SUPER: {
                parser.next();
                return new ParsedExpressionSuper(position);
            }
            case T_DOLLAR: {
                parser.next();
                return new ParsedDollarExpression(position);
            }
            case T_SQOPEN: {
                parser.next();
                ArrayList<ParsedExpression> contents = new ArrayList<ParsedExpression>();
                if (parser.optional(ZSTokenType.T_SQCLOSE) == null) {
                    while (parser.optional(ZSTokenType.T_SQCLOSE) == null) {
                        contents.add(ParsedExpression.readAssignExpression(parser, options));
                        if (parser.optional(ZSTokenType.T_COMMA) != null) continue;
                        parser.required(ZSTokenType.T_SQCLOSE, "] or , expected");
                        break;
                    }
                }
                return new ParsedExpressionArray(position, contents);
            }
            case T_AOPEN: {
                parser.next();
                ArrayList<ParsedExpression> keys = new ArrayList<ParsedExpression>();
                ArrayList<ParsedExpression> values = new ArrayList<ParsedExpression>();
                while (parser.optional(ZSTokenType.T_ACLOSE) == null) {
                    ParsedExpression expression = ParsedExpression.readAssignExpression(parser, options);
                    if (parser.optional(ZSTokenType.T_COLON) == null) {
                        keys.add(null);
                        values.add(expression);
                    } else {
                        keys.add(expression);
                        values.add(ParsedExpression.readAssignExpression(parser, options));
                    }
                    if (parser.optional(ZSTokenType.T_COMMA) != null) continue;
                    parser.required(ZSTokenType.T_ACLOSE, "} or , expected");
                    break;
                }
                return new ParsedExpressionMap(position, keys, values);
            }
            case K_TRUE: {
                parser.next();
                return new ParsedExpressionBool(position, true);
            }
            case K_FALSE: {
                parser.next();
                return new ParsedExpressionBool(position, false);
            }
            case K_NULL: {
                parser.next();
                return new ParsedExpressionNull(position);
            }
            case T_BROPEN: {
                parser.next();
                ArrayList<ParsedExpression> expressions = new ArrayList<ParsedExpression>();
                while (((ZSToken)parser.peek()).type != ZSTokenType.T_BRCLOSE) {
                    expressions.add(ParsedExpression.readAssignExpression(parser, options));
                    if (parser.optional(ZSTokenType.T_COMMA) != null) continue;
                }
                parser.required(ZSTokenType.T_BRCLOSE, ") expected");
                return new ParsedExpressionBracket(position, expressions);
            }
            case K_NEW: {
                parser.next();
                IParsedType type = IParsedType.parse(parser);
                ParsedCallArguments newArguments = ParsedCallArguments.NONE;
                if (parser.isNext(ZSTokenType.T_BROPEN) || parser.isNext(ZSTokenType.T_LESS)) {
                    newArguments = ParsedCallArguments.parse(parser);
                }
                return new ParsedNewExpression(position, type, newArguments);
            }
            case K_THROW: {
                parser.next();
                ParsedExpression value = ParsedExpression.parse(parser);
                return new ParsedThrowExpression(position, value);
            }
            case K_PANIC: {
                parser.next();
                ParsedExpression value = ParsedExpression.parse(parser);
                return new ParsedPanicExpression(position, value);
            }
            case K_MATCH: {
                parser.next();
                ParsedExpression source = ParsedExpression.parse(parser);
                parser.required(ZSTokenType.T_AOPEN, "{ expected");
                ArrayList<ParsedMatchExpression.Case> cases = new ArrayList<ParsedMatchExpression.Case>();
                while (parser.optional(ZSTokenType.T_ACLOSE) == null) {
                    ParsedExpression key = null;
                    if (parser.optional(ZSTokenType.K_DEFAULT) == null) {
                        key = ParsedExpression.parse(parser, new ParsingOptions(false));
                    }
                    parser.required(ZSTokenType.T_LAMBDA, "=> expected");
                    ParsedExpression value = ParsedExpression.parse(parser);
                    cases.add(new ParsedMatchExpression.Case(key, value));
                    if (parser.optional(ZSTokenType.T_COMMA) != null) continue;
                    break;
                }
                parser.required(ZSTokenType.T_ACLOSE, "} expected");
                return new ParsedMatchExpression(position, source, cases);
            }
            case T_LESS: {
                parser.next();
                if (parser.bracketParser == null) {
                    throw new ParseException(position, "Bracket expression detected but no bracket parser present");
                }
                return parser.bracketParser.parse(position, parser);
            }
        }
        IParsedType type = IParsedType.parse(parser);
        if (type == null) {
            ZSToken last = (ZSToken)parser.next();
            throw new ParseException(parser.getPosition(), "Invalid expression, last token: " + last.content);
        }
        return new ParsedTypeExpression(position, type);
    }

    public abstract IPartialExpression compile(ExpressionScope var1) throws CompileException;

    public Expression compileKey(ExpressionScope scope) throws CompileException {
        return this.compile(scope).eval();
    }

    public SwitchValue compileToSwitchValue(TypeID type, ExpressionScope scope) throws CompileException {
        throw new CompileException(this.position, CompileExceptionCode.INVALID_SWITCH_CASE, "Invalid switch case");
    }

    public ParsedFunctionHeader toLambdaHeader() throws ParseException {
        throw new ParseException(this.position, "Not a valid lambda header");
    }

    public ParsedFunctionParameter toLambdaParameter() throws ParseException {
        throw new ParseException(this.position, "Not a valid lambda parameter");
    }

    public boolean isCompatibleWith(BaseScope scope, TypeID type) {
        return true;
    }

    public abstract boolean hasStrongType();

    public static class ParsingOptions {
        public static final ParsingOptions DEFAULT = new ParsingOptions(true);
        public final boolean allowLambda;

        public ParsingOptions(boolean allowLambda) {
            this.allowLambda = allowLambda;
        }
    }
}

