/*
 * Decompiled with CFR 0.152.
 */
package minetweaker.mods.ic2.machines;

import ic2.api.recipe.RecipeOutput;
import ic2.api.recipe.Recipes;
import minetweaker.MineTweakerAPI;
import minetweaker.annotations.ModOnly;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import minetweaker.api.minecraft.MineTweakerMC;
import minetweaker.mods.ic2.IC2RecipeInput;
import minetweaker.mods.ic2.MachineAddRecipeAction;
import net.minecraft.nbt.NBTTagCompound;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.ic2.ThermalCentrifuge")
@ModOnly(value={"IC2"})
public class ThermalCentrifuge {
    @ZenMethod
    public static void addRecipe(IItemStack[] output, IIngredient ingredient, int minHeat) {
        if (ingredient.getAmount() < 0) {
            MineTweakerAPI.logWarning("invalid ingredient: " + ingredient + " - stack size not known");
        } else {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74768_a("minHeat", minHeat);
            MineTweakerAPI.apply(new MachineAddRecipeAction("thermal centrifuge", Recipes.centrifuge, MineTweakerMC.getItemStacks(output), tag, new IC2RecipeInput(ingredient)));
        }
    }

    @ZenMethod
    public static void addRecipe(IItemStack output, IIngredient ingredient, int minHeat) {
        ThermalCentrifuge.addRecipe(new IItemStack[]{output}, ingredient, minHeat);
    }

    @ZenMethod
    public static IItemStack[] getOutput(IItemStack input) {
        RecipeOutput output = Recipes.centrifuge.getOutputFor(MineTweakerMC.getItemStack(input), false);
        if (output == null || output.items.isEmpty()) {
            return null;
        }
        return MineTweakerMC.getIItemStacks(output.items);
    }
}

