/*
 * Decompiled with CFR 0.152.
 */
package minetweaker.mods.mfr.machines;

import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.annotations.ModOnly;
import minetweaker.mc1710.util.MineTweakerPlatformUtils;
import net.minecraft.entity.EntityLivingBase;
import powercrystals.minefactoryreloaded.MFRRegistry;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.mfr.AutoSpawner")
@ModOnly(value={"MineFactoryReloaded"})
public class AutoSpawner {
    @ZenMethod
    public static void addBlacklist(String entityClassName) {
        MineTweakerAPI.apply(new AutoSpawnerAddBlacklistAction(MineTweakerPlatformUtils.getLivingEntityClass(entityClassName)));
    }

    @ZenMethod
    public static void removeBlacklist(String entityClassName) {
        MineTweakerAPI.apply(new AutoSpawnerRemoveBlacklistAction(MineTweakerPlatformUtils.getLivingEntityClass(entityClassName)));
    }

    private static class AutoSpawnerRemoveBlacklistAction
    implements IUndoableAction {
        private final Class<? extends EntityLivingBase> entityClass;
        private final boolean existed;

        public AutoSpawnerRemoveBlacklistAction(Class<? extends EntityLivingBase> entityClass) {
            this.entityClass = entityClass;
            this.existed = MFRRegistry.getAutoSpawnerClassBlacklist().contains(entityClass);
        }

        @Override
        public void apply() {
            if (this.existed) {
                MFRRegistry.getAutoSpawnerClassBlacklist().remove(this.entityClass);
            }
        }

        @Override
        public boolean canUndo() {
            return true;
        }

        @Override
        public void undo() {
            if (this.existed) {
                MFRRegistry.getAutoSpawnerClassBlacklist().add(this.entityClass);
            }
        }

        @Override
        public String describe() {
            return "Removing auto-spawner blacklist " + this.entityClass.getCanonicalName();
        }

        @Override
        public String describeUndo() {
            return "Restoring auto-spawner blacklist " + this.entityClass.getCanonicalName();
        }

        @Override
        public Object getOverrideKey() {
            return null;
        }
    }

    private static class AutoSpawnerAddBlacklistAction
    implements IUndoableAction {
        private final Class<? extends EntityLivingBase> entityClass;
        private final boolean existed;

        public AutoSpawnerAddBlacklistAction(Class<? extends EntityLivingBase> entityClass) {
            this.entityClass = entityClass;
            this.existed = MFRRegistry.getAutoSpawnerClassBlacklist().contains(entityClass);
        }

        @Override
        public void apply() {
            if (!this.existed) {
                MFRRegistry.registerAutoSpawnerBlacklistClass(this.entityClass);
            }
        }

        @Override
        public boolean canUndo() {
            return true;
        }

        @Override
        public void undo() {
            if (!this.existed) {
                MFRRegistry.getAutoSpawnerClassBlacklist().remove(this.entityClass);
            }
        }

        @Override
        public String describe() {
            return "Adding auto-spawner blacklist " + this.entityClass.getCanonicalName();
        }

        @Override
        public String describeUndo() {
            return "Removing auto-spawner blacklist " + this.entityClass.getCanonicalName();
        }

        @Override
        public Object getOverrideKey() {
            return null;
        }
    }
}

