/*
 * Decompiled with CFR 0.152.
 */
package minetweaker.mc18;

import java.io.File;
import minetweaker.MineTweakerAPI;
import minetweaker.MineTweakerImplementationAPI;
import minetweaker.api.logger.FileLogger;
import minetweaker.mc18.FMLEventHandler;
import minetweaker.mc18.ForgeEventHandler;
import minetweaker.mc18.MCPlatformFunctions;
import minetweaker.mc18.MineTweakerRegistry;
import minetweaker.mc18.brackets.ItemBracketHandler;
import minetweaker.mc18.brackets.LiquidBracketHandler;
import minetweaker.mc18.brackets.OreBracketHandler;
import minetweaker.mc18.client.MCClient;
import minetweaker.mc18.formatting.MCFormatter;
import minetweaker.mc18.furnace.FuelTweaker;
import minetweaker.mc18.furnace.MCFurnaceManager;
import minetweaker.mc18.game.MCGame;
import minetweaker.mc18.mods.MCLoadedMods;
import minetweaker.mc18.network.MineTweakerCopyClipboardHandler;
import minetweaker.mc18.network.MineTweakerCopyClipboardPacket;
import minetweaker.mc18.network.MineTweakerLoadScriptsHandler;
import minetweaker.mc18.network.MineTweakerLoadScriptsPacket;
import minetweaker.mc18.network.MineTweakerOpenBrowserHandler;
import minetweaker.mc18.network.MineTweakerOpenBrowserPacket;
import minetweaker.mc18.oredict.MCOreDict;
import minetweaker.mc18.recipes.MCRecipeManager;
import minetweaker.mc18.server.MCServer;
import minetweaker.mc18.util.MineTweakerHacks;
import minetweaker.mc18.util.MineTweakerPlatformUtils;
import minetweaker.mc18.vanilla.MCVanilla;
import minetweaker.runtime.GlobalRegistry;
import minetweaker.runtime.IScriptProvider;
import minetweaker.runtime.providers.ScriptProviderCascade;
import minetweaker.runtime.providers.ScriptProviderCustom;
import minetweaker.runtime.providers.ScriptProviderDirectory;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLLoadCompleteEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppedEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;

@Mod(modid="MineTweaker3", version="3.1.0", acceptedMinecraftVersions="[1.8.9]")
public class MineTweakerMod {
    public static final String MODID = "MineTweaker3";
    public static final String MCVERSION = "1.8.9";
    public static final SimpleNetworkWrapper NETWORK = NetworkRegistry.INSTANCE.newSimpleChannel("MineTweaker3");
    private static final String[] REGISTRIES = new String[]{"minetweaker.mods.jei.ClassRegistry"};
    private static final String[] REGISTRY_DESCRIPTIONS = new String[]{"JEI mod support"};
    public static MinecraftServer server;
    @Mod.Instance(value="MineTweaker3")
    public static MineTweakerMod INSTANCE;
    public final MCRecipeManager recipes;
    private final IScriptProvider scriptsGlobal;
    private final ScriptProviderCustom scriptsIMC;

    public MineTweakerMod() {
        MCOreDict ore = new MCOreDict();
        this.recipes = new MCRecipeManager();
        MCFurnaceManager furnace = new MCFurnaceManager();
        MCGame game = new MCGame();
        MCLoadedMods mods = new MCLoadedMods();
        MCFormatter formatter = new MCFormatter();
        MCVanilla vanilla = new MCVanilla();
        MineTweakerImplementationAPI.init(ore, this.recipes, furnace, game, mods, formatter, vanilla);
        MineTweakerImplementationAPI.logger.addLogger(new FileLogger(new File("minetweaker.log")));
        MineTweakerImplementationAPI.platform = MCPlatformFunctions.INSTANCE;
        File globalDir = new File("scripts");
        if (!globalDir.exists()) {
            globalDir.mkdirs();
        }
        this.scriptsIMC = new ScriptProviderCustom("intermod");
        this.scriptsGlobal = new ScriptProviderDirectory(globalDir);
        MineTweakerImplementationAPI.setScriptProvider(this.scriptsGlobal);
    }

    @Mod.EventHandler
    public void onIMCEvent(FMLInterModComms.IMCEvent event) {
        for (FMLInterModComms.IMCMessage imcMessage : event.getMessages()) {
            if (!imcMessage.key.equalsIgnoreCase("addMineTweakerScript")) continue;
            if (imcMessage.isStringMessage()) {
                this.scriptsIMC.add(imcMessage.getSender() + "::imc", imcMessage.getStringValue());
                continue;
            }
            if (!imcMessage.isNBTMessage()) continue;
            NBTTagCompound message = imcMessage.getNBTValue();
            this.scriptsIMC.add(imcMessage.getSender() + "::" + message.func_74779_i("name"), message.func_74779_i("content"));
        }
    }

    @Mod.EventHandler
    public void onLoad(FMLPreInitializationEvent ev) {
        MinecraftForge.EVENT_BUS.register((Object)new ForgeEventHandler());
        FMLCommonHandler.instance().bus().register((Object)new FMLEventHandler());
    }

    @Mod.EventHandler
    public void onPostInit(FMLPostInitializationEvent ev) {
        MineTweakerAPI.registerClassRegistry(MineTweakerRegistry.class);
        for (int i = 0; i < REGISTRIES.length; ++i) {
            MineTweakerAPI.registerClassRegistry(REGISTRIES[i], REGISTRY_DESCRIPTIONS[i]);
        }
        FuelTweaker.INSTANCE.register();
    }

    @Mod.EventHandler
    public void onComplete(FMLLoadCompleteEvent ev) {
        MineTweakerAPI.logInfo("MineTweaker: Building registry");
        ItemBracketHandler.rebuildItemRegistry();
        LiquidBracketHandler.rebuildLiquidRegistry();
        MineTweakerAPI.logInfo("MineTweaker: Sucessfully built item registry");
        GlobalRegistry.registerBracketHandler(new ItemBracketHandler());
        GlobalRegistry.registerBracketHandler(new LiquidBracketHandler());
        GlobalRegistry.registerBracketHandler(new OreBracketHandler());
    }

    @Mod.EventHandler
    public void onServerAboutToStart(FMLServerAboutToStartEvent ev) {
        File scriptsDir;
        server = ev.getServer();
        if (MineTweakerPlatformUtils.isClient()) {
            MineTweakerAPI.client = new MCClient();
        }
        if (!(scriptsDir = new File(MineTweakerHacks.getWorldDirectory(ev.getServer()), "scripts")).exists()) {
            scriptsDir.mkdir();
        }
        ScriptProviderDirectory scriptsLocal = new ScriptProviderDirectory(scriptsDir);
        ScriptProviderCascade cascaded = new ScriptProviderCascade(this.scriptsIMC, this.scriptsGlobal, scriptsLocal);
        MineTweakerImplementationAPI.setScriptProvider(cascaded);
        MineTweakerImplementationAPI.onServerStart(new MCServer(ev.getServer()));
    }

    @Mod.EventHandler
    public void onServerStarting(FMLServerStartingEvent ev) {
        server = ev.getServer();
    }

    @Mod.EventHandler
    public void onServerStopped(FMLServerStoppedEvent ev) {
        MineTweakerImplementationAPI.onServerStop();
        MineTweakerImplementationAPI.setScriptProvider(this.scriptsGlobal);
        server = null;
    }

    static {
        NETWORK.registerMessage(MineTweakerLoadScriptsHandler.class, MineTweakerLoadScriptsPacket.class, 0, Side.CLIENT);
        NETWORK.registerMessage(MineTweakerOpenBrowserHandler.class, MineTweakerOpenBrowserPacket.class, 1, Side.CLIENT);
        NETWORK.registerMessage(MineTweakerCopyClipboardHandler.class, MineTweakerCopyClipboardPacket.class, 2, Side.CLIENT);
    }
}

