/*
 * Decompiled with CFR 0.152.
 */
package minetweaker.mc18.formatting;

import com.mojang.realmsclient.gui.ChatFormatting;
import java.util.Arrays;
import minetweaker.api.formatting.IFormattedText;
import minetweaker.mc18.formatting.IMCFormattedString;

public class FormattedStringJoin
implements IMCFormattedString {
    private final IMCFormattedString[] values;

    public FormattedStringJoin(IMCFormattedString first, IMCFormattedString second) {
        this.values = new IMCFormattedString[]{first, second};
    }

    public FormattedStringJoin(IMCFormattedString[] values) {
        this.values = values;
    }

    @Override
    public String getTooltipString() {
        StringBuilder result = new StringBuilder();
        for (IMCFormattedString value : this.values) {
            result.append(value.getTooltipString());
        }
        return result.toString();
    }

    @Override
    public String getTooltipString(String context) {
        boolean first = true;
        StringBuilder result = new StringBuilder();
        for (IMCFormattedString value : this.values) {
            if (first) {
                first = false;
            } else {
                result.append(context);
            }
            result.append(value.getTooltipString());
            result.append(ChatFormatting.RESET);
        }
        return result.toString();
    }

    @Override
    public IFormattedText add(IFormattedText other) {
        return this.cat(other);
    }

    @Override
    public IFormattedText cat(IFormattedText other) {
        IMCFormattedString[] newValues = Arrays.copyOf(this.values, this.values.length + 1);
        newValues[this.values.length] = (IMCFormattedString)other;
        return new FormattedStringJoin(newValues);
    }
}

