/*
 * Decompiled with CFR 0.152.
 */
package minetweaker.mc18.game;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.block.IBlockDefinition;
import minetweaker.api.entity.IEntityDefinition;
import minetweaker.api.game.IGame;
import minetweaker.api.item.IItemDefinition;
import minetweaker.api.liquid.ILiquidDefinition;
import minetweaker.api.minecraft.MineTweakerMC;
import minetweaker.api.world.IBiome;
import minetweaker.mc18.entity.MCEntityDefinition;
import minetweaker.mc18.item.MCItemDefinition;
import minetweaker.mc18.liquid.MCLiquidDefinition;
import minetweaker.mc18.util.MineTweakerHacks;
import minetweaker.mc18.util.MineTweakerPlatformUtils;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.registry.EntityRegistry;

public class MCGame
implements IGame {
    public static final MCGame INSTANCE = new MCGame();
    private static final Map<String, String> TRANSLATIONS = MineTweakerHacks.getTranslations();
    private static final List<IEntityDefinition> ENTITY_DEFINITIONS = new ArrayList<IEntityDefinition>();
    private boolean locked = false;

    @Override
    public List<IItemDefinition> getItems() {
        ArrayList<IItemDefinition> result = new ArrayList<IItemDefinition>();
        for (ResourceLocation item : Item.field_150901_e.func_148742_b()) {
            result.add(new MCItemDefinition(item.toString(), (Item)Item.field_150901_e.func_82594_a((Object)item)));
        }
        return result;
    }

    @Override
    public List<IBlockDefinition> getBlocks() {
        ArrayList<IBlockDefinition> result = new ArrayList<IBlockDefinition>();
        for (ResourceLocation block : Block.field_149771_c.func_148742_b()) {
            result.add(MineTweakerMC.getBlockDefinition((Block)Block.field_149771_c.func_82594_a((Object)block)));
        }
        return result;
    }

    @Override
    public List<ILiquidDefinition> getLiquids() {
        ArrayList<ILiquidDefinition> result = new ArrayList<ILiquidDefinition>();
        for (Map.Entry entry : FluidRegistry.getRegisteredFluids().entrySet()) {
            result.add(new MCLiquidDefinition((Fluid)entry.getValue()));
        }
        return result;
    }

    @Override
    public List<IBiome> getBiomes() {
        ArrayList<IBiome> result = new ArrayList<IBiome>();
        for (IBiome biome : MineTweakerMC.biomes) {
            if (biome == null) continue;
            result.add(biome);
        }
        return result;
    }

    @Override
    public List<IEntityDefinition> getEntities() {
        Set values = MineTweakerHacks.getEntityClassRegistrations().values();
        if (Iterables.size((Iterable)values) != ENTITY_DEFINITIONS.size()) {
            ENTITY_DEFINITIONS.clear();
            for (EntityRegistry.EntityRegistration entry : values) {
                ENTITY_DEFINITIONS.add(new MCEntityDefinition(entry));
            }
        }
        return ENTITY_DEFINITIONS;
    }

    @Override
    public IEntityDefinition getEntity(String entityName) {
        for (IEntityDefinition ent : this.getEntities()) {
            if (!ent.getName().equalsIgnoreCase(entityName)) continue;
            return ent;
        }
        boolean needsReloading = false;
        for (EntityRegistry.EntityRegistration res : MineTweakerHacks.getEntityClassRegistrations().values()) {
            if (!res.getEntityName().equalsIgnoreCase(entityName)) continue;
            needsReloading = true;
            break;
        }
        if (needsReloading) {
            ENTITY_DEFINITIONS.clear();
            for (EntityRegistry.EntityRegistration entry : MineTweakerHacks.getEntityClassRegistrations().values()) {
                ENTITY_DEFINITIONS.add(new MCEntityDefinition(entry));
            }
        }
        for (IEntityDefinition entity : this.getEntities()) {
            if (!entity.getName().equalsIgnoreCase(entityName)) continue;
            return entity;
        }
        return null;
    }

    @Override
    public void setLocalization(String key, String value) {
        MineTweakerAPI.apply(new SetTranslation(null, key, value));
    }

    @Override
    public void setLocalization(String lang, String key, String value) {
        MineTweakerAPI.apply(new SetTranslation(lang, key, value));
    }

    @Override
    public String localize(String key) {
        return StatCollector.func_74838_a((String)key);
    }

    @Override
    public String localize(String key, String lang) {
        return StatCollector.func_74838_a((String)key);
    }

    @Override
    public void lock() {
        this.locked = true;
    }

    @Override
    public boolean isLocked() {
        return this.locked;
    }

    @Override
    public void signalLockError() {
        MineTweakerAPI.getLogger().logError("Reload of scripts blocked (script lock)");
        if (Minecraft.func_71382_s()) {
            // empty if block
        }
    }

    private static class SetTranslation
    implements IUndoableAction {
        private final String lang;
        private final String key;
        private final String text;
        private String original;
        private boolean added;

        public SetTranslation(String lang, String key, String text) {
            this.lang = lang;
            this.key = key;
            this.text = text;
        }

        @Override
        public void apply() {
            if (this.lang == null || MineTweakerPlatformUtils.isLanguageActive(this.lang)) {
                this.original = (String)TRANSLATIONS.get(this.key);
                TRANSLATIONS.put(this.key, this.text);
                this.added = true;
            } else {
                this.added = false;
            }
        }

        @Override
        public boolean canUndo() {
            return TRANSLATIONS != null;
        }

        @Override
        public void undo() {
            if (this.added) {
                if (this.original == null) {
                    TRANSLATIONS.remove(this.key);
                } else {
                    TRANSLATIONS.put(this.key, this.original);
                }
            }
        }

        @Override
        public String describe() {
            return "Setting localization for the key: " + this.key + " to " + this.text;
        }

        @Override
        public String describeUndo() {
            return "Setting localization for the key: " + this.key + " to " + this.original;
        }

        @Override
        public Object getOverrideKey() {
            return null;
        }
    }
}

