/*
 * Decompiled with CFR 0.152.
 */
package minetweaker.mc18.player;

import minetweaker.MineTweakerAPI;
import minetweaker.api.chat.IChatMessage;
import minetweaker.api.data.IData;
import minetweaker.api.item.IItemStack;
import minetweaker.api.minecraft.MineTweakerMC;
import minetweaker.api.player.IPlayer;
import minetweaker.mc18.MineTweakerMod;
import minetweaker.mc18.data.NBTConverter;
import minetweaker.mc18.network.MineTweakerCopyClipboardPacket;
import minetweaker.mc18.network.MineTweakerOpenBrowserPacket;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class MCPlayer
implements IPlayer {
    private final EntityPlayer player;

    public MCPlayer(EntityPlayer player) {
        this.player = player;
    }

    public EntityPlayer getInternal() {
        return this.player;
    }

    @Override
    public String getId() {
        return null;
    }

    @Override
    public String getName() {
        return this.player.func_70005_c_();
    }

    @Override
    public IData getData() {
        return NBTConverter.from((NBTBase)this.player.getEntityData(), true);
    }

    @Override
    public int getXP() {
        return this.player.field_71068_ca;
    }

    @Override
    public void setXP(int xp) {
        this.player.func_71013_b(this.player.field_71068_ca);
        this.player.func_82242_a(xp);
    }

    @Override
    public void removeXP(int xp) {
        this.player.func_71013_b(xp);
    }

    @Override
    public void update(IData data) {
        NBTConverter.updateMap(this.player.getEntityData(), data);
    }

    @Override
    public void sendChat(IChatMessage message) {
        Object internal = message.getInternal();
        if (!(internal instanceof IChatComponent)) {
            MineTweakerAPI.logError("not a valid chat message");
            return;
        }
        this.player.func_145747_a((IChatComponent)internal);
    }

    @Override
    public void sendChat(String message) {
        this.player.func_145747_a((IChatComponent)new ChatComponentText(message));
    }

    @Override
    public int getHotbarSize() {
        return 9;
    }

    @Override
    public IItemStack getHotbarStack(int i) {
        return i < 0 || i >= 9 ? null : MineTweakerMC.getIItemStack(this.player.field_71071_by.func_70301_a(i));
    }

    @Override
    public int getInventorySize() {
        return this.player.field_71071_by.func_70302_i_();
    }

    @Override
    public IItemStack getInventoryStack(int i) {
        return MineTweakerMC.getIItemStack(this.player.field_71071_by.func_70301_a(i));
    }

    @Override
    public IItemStack getCurrentItem() {
        return MineTweakerMC.getIItemStack(this.player.field_71071_by.func_70448_g());
    }

    @Override
    public boolean isCreative() {
        return this.player.field_71075_bZ.field_75098_d;
    }

    @Override
    public boolean isAdventure() {
        return !this.player.field_71075_bZ.field_75099_e;
    }

    @Override
    public void openBrowser(String url) {
        if (this.player instanceof EntityPlayerMP) {
            MineTweakerMod.NETWORK.sendTo((IMessage)new MineTweakerOpenBrowserPacket(url), (EntityPlayerMP)this.player);
        }
    }

    @Override
    public void copyToClipboard(String value) {
        if (this.player instanceof EntityPlayerMP) {
            MineTweakerMod.NETWORK.sendTo((IMessage)new MineTweakerCopyClipboardPacket(value), (EntityPlayerMP)this.player);
        }
    }

    public boolean equals(Object other) {
        if (other.getClass() != this.getClass()) {
            return false;
        }
        return ((MCPlayer)other).player == this.player;
    }

    public int hashCode() {
        int hash = 5;
        hash = 23 * hash + (this.player != null ? this.player.hashCode() : 0);
        return hash;
    }

    @Override
    public void give(IItemStack stack) {
        this.player.field_71071_by.func_70441_a(MineTweakerMC.getItemStack(stack).func_77946_l());
    }
}

