/*
 * Decompiled with CFR 0.152.
 */
package minetweaker.mc18.server;

import java.util.Arrays;
import java.util.List;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.minecraft.MineTweakerMC;
import minetweaker.api.player.IPlayer;
import minetweaker.api.server.AbstractServer;
import minetweaker.api.server.ICommandFunction;
import minetweaker.api.server.ICommandTabCompletion;
import minetweaker.api.server.ICommandValidator;
import minetweaker.mc18.MineTweakerMod;
import minetweaker.mc18.player.CommandBlockPlayer;
import minetweaker.mc18.player.RconPlayer;
import minetweaker.mc18.server.ServerPlayer;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandHandler;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.server.CommandBlockLogic;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.rcon.RConConsoleSource;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.management.UserListOps;
import net.minecraft.util.BlockPos;

public class MCServer
extends AbstractServer {
    private final MinecraftServer server;

    public MCServer(MinecraftServer server) {
        this.server = server;
    }

    private static IPlayer getPlayer(ICommandSender commandSender) {
        if (commandSender instanceof EntityPlayer) {
            return MineTweakerMC.getIPlayer((EntityPlayer)commandSender);
        }
        if (commandSender instanceof DedicatedServer) {
            return ServerPlayer.INSTANCE;
        }
        if (commandSender instanceof RConConsoleSource) {
            return new RconPlayer(commandSender);
        }
        if (commandSender instanceof CommandBlockLogic) {
            return new CommandBlockPlayer(commandSender);
        }
        System.out.println("Unsupported command sender: " + commandSender);
        System.out.println("player name: " + commandSender.func_70005_c_());
        return null;
    }

    @Override
    public void addCommand(String name, String usage, String[] aliases, ICommandFunction function, ICommandValidator validator, ICommandTabCompletion completion) {
        MCCommand command = new MCCommand(name, usage, aliases, function, validator, completion);
        MineTweakerAPI.apply(new AddCommandAction(command));
    }

    @Override
    public boolean isOp(IPlayer player) {
        if (player == ServerPlayer.INSTANCE) {
            return true;
        }
        UserListOps ops = MineTweakerMod.server.func_71203_ab().func_152603_m();
        if (this.server.func_71262_S() && ops != null) {
            return ops.func_152690_d() || ops.func_152700_a(player.getName()) != null || player instanceof RconPlayer;
        }
        return true;
    }

    @Override
    public boolean isCommandAdded(String name) {
        return MineTweakerMod.server.func_71187_D().func_71555_a().containsKey(name);
    }

    private class AddCommandAction
    implements IUndoableAction {
        private final ICommand command;

        public AddCommandAction(ICommand command) {
            this.command = command;
        }

        @Override
        public void apply() {
            CommandHandler ch = (CommandHandler)MineTweakerMod.server.func_71187_D();
            if (!ch.func_71555_a().containsValue(this.command)) {
                ch.func_71560_a(this.command);
            }
        }

        @Override
        public boolean canUndo() {
            return true;
        }

        @Override
        public void undo() {
        }

        @Override
        public String describe() {
            CommandHandler ch = (CommandHandler)MineTweakerMod.server.func_71187_D();
            if (!ch.func_71555_a().containsValue(this.command)) {
                return "Adding command " + this.command.func_71517_b();
            }
            return "Tried to add command: " + this.command.func_71517_b() + ", failed. THIS IS NOT AN ERROR!";
        }

        @Override
        public String describeUndo() {
            return "Tried to remove command: " + this.command.func_71517_b() + ", failed. THIS IS NOT AN ERROR!";
        }

        @Override
        public Object getOverrideKey() {
            return null;
        }
    }

    private class MCCommand
    implements ICommand {
        private final String name;
        private final String usage;
        private final List<String> aliases;
        private final ICommandFunction function;
        private final ICommandValidator validator;
        private final ICommandTabCompletion completion;

        public MCCommand(String name, String usage, String[] aliases, ICommandFunction function, ICommandValidator validator, ICommandTabCompletion completion) {
            this.name = name;
            this.usage = usage;
            this.aliases = Arrays.asList(aliases);
            this.function = function;
            this.validator = validator;
            this.completion = completion;
        }

        public String func_71517_b() {
            return this.name;
        }

        public String func_71518_a(ICommandSender var1) {
            return this.usage;
        }

        public List<String> func_71514_a() {
            return this.aliases;
        }

        public boolean func_71519_b(ICommandSender var1) {
            if (this.validator == null) {
                return true;
            }
            return this.validator.canExecute(MCServer.getPlayer(var1));
        }

        public boolean func_82358_a(String[] var1, int var2) {
            return false;
        }

        public void func_71515_b(ICommandSender sender, String[] args) throws CommandException {
            this.function.execute(args, MCServer.getPlayer(sender));
        }

        public List func_180525_a(ICommandSender sender, String[] args, BlockPos pos) {
            if (this.completion != null) {
                return Arrays.asList(this.completion.getTabCompletionOptions(args, MCServer.getPlayer(sender)));
            }
            return null;
        }

        public int compareTo(ICommand o) {
            return 0;
        }
    }
}

