/*
 * Decompiled with CFR 0.152.
 */
package minetweaker.mc19.oredict;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemCondition;
import minetweaker.api.item.IItemStack;
import minetweaker.api.item.IItemTransformer;
import minetweaker.api.item.IngredientOr;
import minetweaker.api.item.IngredientStack;
import minetweaker.api.liquid.ILiquidStack;
import minetweaker.api.minecraft.MineTweakerMC;
import minetweaker.api.oredict.IOreDictEntry;
import minetweaker.api.oredict.IngredientOreDict;
import minetweaker.api.player.IPlayer;
import minetweaker.mc19.util.MineTweakerHacks;
import minetweaker.util.ArrayUtil;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class MCOreDictEntry
implements IOreDictEntry {
    private static final List<ArrayList<ItemStack>> OREDICT_CONTENTS = MineTweakerHacks.getOreIdStacks();
    private static final List<ArrayList<ItemStack>> OREDICT_CONTENTS_UN = MineTweakerHacks.getOreIdStacksUn();
    private final String id;

    public MCOreDictEntry(String id) {
        this.id = id;
    }

    @Override
    public String getName() {
        return this.id;
    }

    @Override
    public boolean isEmpty() {
        return OreDictionary.getOres((String)this.getName()).isEmpty();
    }

    @Override
    public IItemStack getFirstItem() {
        return this.getItems().get(0);
    }

    @Override
    public void add(IItemStack item) {
        ItemStack stack = MineTweakerMC.getItemStack(item);
        if (stack != null) {
            MineTweakerAPI.apply(new ActionAddItem(this.id, stack));
        }
    }

    @Override
    public void addItems(IItemStack[] items) {
        for (IItemStack item : items) {
            ItemStack stack = MineTweakerMC.getItemStack(item);
            if (stack == null) continue;
            MineTweakerAPI.apply(new ActionAddItem(this.id, stack));
        }
    }

    @Override
    public void addAll(IOreDictEntry entry) {
        if (entry instanceof MCOreDictEntry) {
            MineTweakerAPI.apply(new ActionAddAll(this.id, ((MCOreDictEntry)entry).id));
        } else {
            MineTweakerAPI.logError("not a valid entry");
        }
    }

    @Override
    public void remove(IItemStack item) {
        ItemStack result = null;
        for (ItemStack itemStack : OreDictionary.getOres((String)this.getName())) {
            if (!item.matches(MineTweakerMC.getIItemStackWildcardSize(itemStack))) continue;
            result = itemStack;
            break;
        }
        if (result != null) {
            MineTweakerAPI.apply(new ActionRemoveItem(this.id, result));
        }
    }

    @Override
    public void removeItems(IItemStack[] items) {
        for (IItemStack item : items) {
            ItemStack result = null;
            for (ItemStack itemStack : OreDictionary.getOres((String)this.id)) {
                if (!item.matches(MineTweakerMC.getIItemStackWildcardSize(itemStack))) continue;
                result = itemStack;
                break;
            }
            if (result == null) continue;
            MineTweakerAPI.apply(new ActionRemoveItem(this.id, result));
        }
    }

    @Override
    public boolean contains(IItemStack item) {
        for (ItemStack itemStack : OreDictionary.getOres((String)this.getName())) {
            if (!MineTweakerMC.getIItemStackWildcardSize(itemStack).matches(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void mirror(IOreDictEntry other) {
        if (other instanceof MCOreDictEntry) {
            MineTweakerAPI.apply(new ActionMirror(this.id, ((MCOreDictEntry)other).id));
        } else {
            MineTweakerAPI.logError("not a valid oredict entry");
        }
    }

    @Override
    public String getMark() {
        return null;
    }

    @Override
    public int getAmount() {
        return 1;
    }

    @Override
    public List<IItemStack> getItems() {
        ArrayList<IItemStack> result = new ArrayList<IItemStack>();
        for (ItemStack item : OreDictionary.getOres((String)this.getName())) {
            result.add(MineTweakerMC.getIItemStackWildcardSize(item));
        }
        return result;
    }

    @Override
    public List<ILiquidStack> getLiquids() {
        return Collections.emptyList();
    }

    @Override
    public IIngredient amount(int amount) {
        return new IngredientStack(this, amount);
    }

    @Override
    public IIngredient transform(IItemTransformer transformer) {
        return new IngredientOreDict(this, null, ArrayUtil.EMPTY_CONDITIONS, new IItemTransformer[]{transformer});
    }

    @Override
    public IIngredient only(IItemCondition condition) {
        return new IngredientOreDict(this, null, new IItemCondition[]{condition}, ArrayUtil.EMPTY_TRANSFORMERS);
    }

    @Override
    public IIngredient marked(String mark) {
        return new IngredientOreDict(this, mark, ArrayUtil.EMPTY_CONDITIONS, ArrayUtil.EMPTY_TRANSFORMERS);
    }

    @Override
    public IIngredient or(IIngredient ingredient) {
        return new IngredientOr(this, ingredient);
    }

    @Override
    public boolean matches(IItemStack item) {
        return this.contains(item);
    }

    @Override
    public boolean matches(ILiquidStack liquid) {
        return false;
    }

    @Override
    public boolean contains(IIngredient ingredient) {
        List<IItemStack> items = ingredient.getItems();
        for (IItemStack item : items) {
            if (this.matches(item)) continue;
            return false;
        }
        return true;
    }

    @Override
    public IItemStack applyTransform(IItemStack item, IPlayer byPlayer) {
        return item;
    }

    @Override
    public boolean hasTransformers() {
        return false;
    }

    @Override
    public Object getInternal() {
        return this.id;
    }

    public String toString() {
        return "<ore:" + this.id + ">";
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object other) {
        if (!(other instanceof MCOreDictEntry)) {
            return false;
        }
        return ((MCOreDictEntry)other).id == this.id;
    }

    private static class ActionAddAll
    implements IUndoableAction {
        private final String idTarget;
        private final String idSource;

        public ActionAddAll(String idTarget, String idSource) {
            this.idTarget = idTarget;
            this.idSource = idSource;
        }

        @Override
        public void apply() {
            for (ItemStack stack : OreDictionary.getOres((String)this.idSource)) {
                OreDictionary.registerOre((String)this.idTarget, (ItemStack)stack);
            }
        }

        @Override
        public boolean canUndo() {
            return true;
        }

        @Override
        public void undo() {
            int targetOreId = OreDictionary.getOreID((String)this.idTarget);
            for (ItemStack stack : OreDictionary.getOres((String)this.idSource)) {
                ((ArrayList)OREDICT_CONTENTS.get(targetOreId)).remove(stack);
            }
        }

        @Override
        public String describe() {
            return "Copying contents of ore dictionary entry " + this.idSource + " to " + this.idTarget;
        }

        @Override
        public String describeUndo() {
            return "Removing contents of ore dictionary entry " + this.idSource + " from " + this.idTarget;
        }

        @Override
        public Object getOverrideKey() {
            return null;
        }
    }

    private static class ActionRemoveItem
    implements IUndoableAction {
        private final String id;
        private final ItemStack item;

        public ActionRemoveItem(String id, ItemStack item) {
            this.id = id;
            this.item = item;
        }

        @Override
        public void apply() {
            int oreId = OreDictionary.getOreID((String)this.id);
            ((ArrayList)OREDICT_CONTENTS.get(oreId)).remove(this.item);
        }

        @Override
        public boolean canUndo() {
            return true;
        }

        @Override
        public void undo() {
            int oreId = OreDictionary.getOreID((String)this.id);
            ((ArrayList)OREDICT_CONTENTS.get(oreId)).add(this.item);
        }

        @Override
        public String describe() {
            return "Removing " + this.item.func_82833_r() + " from ore dictionary entry " + this.id;
        }

        @Override
        public String describeUndo() {
            return "Restoring " + this.item.func_82833_r() + " to ore dictionary entry " + this.id;
        }

        @Override
        public Object getOverrideKey() {
            return null;
        }
    }

    private static class ActionMirror
    implements IUndoableAction {
        private final String idTarget;
        private final String idSource;
        private final ArrayList<ItemStack> targetCopy;
        private final ArrayList<ItemStack> targetCopyUn;

        public ActionMirror(String idTarget, String idSource) {
            this.idTarget = idTarget;
            this.idSource = idSource;
            int targetOreId = OreDictionary.getOreID((String)idTarget);
            this.targetCopy = (ArrayList)OREDICT_CONTENTS.get(targetOreId);
            this.targetCopyUn = (ArrayList)OREDICT_CONTENTS_UN.get(targetOreId);
        }

        @Override
        public void apply() {
            int sourceOreId = OreDictionary.getOreID((String)this.idSource);
            int targetOreId = OreDictionary.getOreID((String)this.idTarget);
            OREDICT_CONTENTS.set(targetOreId, OREDICT_CONTENTS.get(sourceOreId));
            OREDICT_CONTENTS_UN.set(targetOreId, OREDICT_CONTENTS_UN.get(sourceOreId));
        }

        @Override
        public boolean canUndo() {
            return true;
        }

        @Override
        public void undo() {
            int targetOreId = OreDictionary.getOreID((String)this.idTarget);
            OREDICT_CONTENTS.set(targetOreId, this.targetCopy);
            OREDICT_CONTENTS_UN.set(targetOreId, this.targetCopyUn);
        }

        @Override
        public String describe() {
            return "Mirroring " + this.idSource + " to " + this.idTarget;
        }

        @Override
        public String describeUndo() {
            return "Undoing mirror of " + this.idSource + " to " + this.idTarget;
        }

        @Override
        public Object getOverrideKey() {
            return null;
        }
    }

    private static class ActionAddItem
    implements IUndoableAction {
        private final String id;
        private final ItemStack item;

        public ActionAddItem(String id, ItemStack item) {
            this.id = id;
            this.item = item;
        }

        @Override
        public void apply() {
            OreDictionary.registerOre((String)this.id, (ItemStack)this.item);
        }

        @Override
        public boolean canUndo() {
            return true;
        }

        @Override
        public void undo() {
            int oreId = OreDictionary.getOreID((String)this.id);
            ((ArrayList)OREDICT_CONTENTS.get(oreId)).remove(this.item);
        }

        @Override
        public String describe() {
            return "Adding " + this.item.func_82833_r() + " to ore dictionary entry " + this.id;
        }

        @Override
        public String describeUndo() {
            return "Removing " + this.item.func_82833_r() + " from ore dictionary entry " + this.id;
        }

        @Override
        public Object getOverrideKey() {
            return null;
        }
    }
}

