/*
 * Decompiled with CFR 0.152.
 */
package stanhebben.zenscript.type.casting;

import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import stanhebben.zenscript.compiler.IEnvironmentMethod;
import stanhebben.zenscript.type.ZenType;
import stanhebben.zenscript.type.ZenTypeArrayBasic;
import stanhebben.zenscript.type.casting.ICastingRule;
import stanhebben.zenscript.util.MethodOutput;

public class CastingRuleArrayArray
implements ICastingRule {
    private final ICastingRule base;
    private final ZenTypeArrayBasic from;
    private final ZenTypeArrayBasic to;

    public CastingRuleArrayArray(ICastingRule base, ZenTypeArrayBasic from, ZenTypeArrayBasic to) {
        this.base = base;
        this.from = from;
        this.to = to;
    }

    @Override
    public void compile(IEnvironmentMethod method) {
        MethodOutput output = method.getOutput();
        Type fromType = this.from.getBaseType().toASMType();
        Type toType = this.to.getBaseType().toASMType();
        int result = output.local(this.to.toASMType());
        output.dup();
        output.arrayLength();
        output.newArray(toType);
        output.storeObject(result);
        output.iConst0();
        Label lbl = new Label();
        output.label(lbl);
        output.dupX1();
        output.dupX1();
        output.arrayLoad(fromType);
        if (this.base != null) {
            this.base.compile(method);
        }
        output.loadObject(result);
        output.dupX2();
        output.dupX2();
        output.arrayStore(toType);
        output.pop();
        output.iConst1();
        output.iAdd();
        output.dupX1();
        output.arrayLength();
        output.ifICmpGE(lbl);
        output.pop();
        output.pop();
        output.loadObject(result);
    }

    @Override
    public ZenType getInputType() {
        return this.from;
    }

    @Override
    public ZenType getResultingType() {
        return this.to;
    }
}

